/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trees;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractSmallTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class WillowTreeFeature
extends AbstractSmallTreeFeature<TreeFeatureConfig> {
    public WillowTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> function) {
        super(function);
    }

    protected boolean place(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = 5 + rand.nextInt(3) + rand.nextInt(4);
        Optional optional = this.func_227212_a_(world, height, 3, 3, pos, config);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos blockpos = (BlockPos)optional.get();
        this.setDirtAt(world, blockpos.func_177977_b(), blockpos);
        this.func_227213_a_(world, rand, height, pos, 0, logs, box, config);
        return true;
    }

    protected void func_227213_a_(IWorldGenerationReader world, Random rand, int a, BlockPos pos, int c, Set<BlockPos> logs, MutableBoundingBox box, TreeFeatureConfig config) {
        int baseHeight = 3 + rand.nextInt(4);
        Direction facing = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        if (pos.func_177956_o() < world.getMaxHeight() - baseHeight - 1) {
            BlockPos pos1 = pos.func_177976_e();
            BlockPos pos2 = pos.func_177974_f();
            BlockPos pos3 = pos.func_177978_c();
            BlockPos pos4 = pos.func_177968_d();
            this.func_227216_a_(world, rand, pos, logs, box, (BaseTreeFeatureConfig)config);
            if (rand.nextInt(5) < 4) {
                this.func_227216_a_(world, rand, pos1, logs, box, (BaseTreeFeatureConfig)config);
            }
            if (rand.nextInt(5) < 4) {
                this.func_227216_a_(world, rand, pos2, logs, box, (BaseTreeFeatureConfig)config);
            }
            if (rand.nextInt(5) < 4) {
                this.func_227216_a_(world, rand, pos3, logs, box, (BaseTreeFeatureConfig)config);
            }
            if (rand.nextInt(5) < 4) {
                this.func_227216_a_(world, rand, pos4, logs, box, (BaseTreeFeatureConfig)config);
            }
        }
        this.func_227216_a_(world, rand, pos.func_177984_a(), logs, box, (BaseTreeFeatureConfig)config);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos shamalamadingdong = new BlockPos(x, y, z);
        for (int h = 0; h <= baseHeight; ++h) {
            if (rand.nextInt(8) < 5) {
                x += facing.func_82601_c();
                z += facing.func_82599_e();
            }
            if (rand.nextInt(6) < 5) {
                ++y;
            }
            BlockPos logpos = new BlockPos(x, y, z);
            this.func_227216_a_(world, rand, logpos, logs, box, (BaseTreeFeatureConfig)config);
            if (rand.nextInt(2) == 0) {
                this.func_227216_a_(world, rand, logpos.func_177977_b(), logs, box, (BaseTreeFeatureConfig)config);
            }
            shamalamadingdong = logpos;
        }
        this.generateBranches(world, rand, shamalamadingdong, logs, box, config);
    }

    private void generateBranches(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, MutableBoundingBox box, TreeFeatureConfig config) {
        int numBranches = 2;
        Direction facing = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        ArrayList<BlockPos> outerLeaves = new ArrayList<BlockPos>();
        BlockState leaf = config.field_227369_n_.func_225574_a_(rand, pos);
        for (int i = 0; i <= numBranches; ++i) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            Direction temp = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            if (!facing.func_176743_c().equals((Object)temp.func_176743_c())) {
                facing = temp;
            }
            int length = rand.nextInt(3) + 2;
            for (int h = 0; h <= length; ++h) {
                x += facing.func_82601_c();
                z += facing.func_82599_e();
                if (rand.nextInt(4) < 2) {
                    ++y;
                }
                BlockPos logpos = new BlockPos(x, y, z);
                this.func_227216_a_(world, rand, logpos, logs, box, (BaseTreeFeatureConfig)config);
                if (rand.nextInt(2) == 0) {
                    this.func_227216_a_(world, rand, logpos.func_177977_b(), logs, box, (BaseTreeFeatureConfig)config);
                }
                for (int up = -rand.nextInt(3); up <= rand.nextInt(2) + 1; ++up) {
                    for (int west = -rand.nextInt(3); west <= rand.nextInt(2) + 1; ++west) {
                        for (int north = -rand.nextInt(3); north <= rand.nextInt(2) + 1; ++north) {
                            BlockPos leafpos = logpos.func_177981_b(up).func_177985_f(west).func_177964_d(north);
                            if (Math.abs(up) != 1 && Math.abs(west) != 1 && Math.abs(north) != 1) {
                                if (rand.nextInt(14) >= 3 || !world.func_217375_a(leafpos, p -> p.func_177230_c() == Blocks.field_150350_a)) continue;
                                world.func_180501_a(leafpos, leaf, 2);
                                outerLeaves.add(leafpos);
                                continue;
                            }
                            if (!world.func_217375_a(leafpos, p -> p.func_177230_c() == Blocks.field_150350_a)) continue;
                            world.func_180501_a(leafpos, leaf, 2);
                        }
                    }
                }
            }
        }
        this.generateVines(world, rand, outerLeaves);
    }

    private void generateVines(IWorldGenerationReader world, Random rand, ArrayList<BlockPos> outerLeaves) {
        Iterator<BlockPos> iterator = outerLeaves.iterator();
        while (iterator.hasNext()) {
            int i;
            BlockPos pos;
            BlockPos vinepos = pos = iterator.next();
            BlockState state = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176279_N, (Comparable)Boolean.valueOf(true));
            int length = 3 + rand.nextInt(5);
            for (i = 0; i < length; ++i) {
                vinepos = pos.func_177978_c().func_177979_c(i);
                if (!world.func_217375_a(vinepos, p -> p.func_177230_c() == Blocks.field_150350_a)) continue;
                world.func_180501_a(vinepos, state, 2);
            }
            length = 3 + rand.nextInt(5);
            state = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176273_b, (Comparable)Boolean.valueOf(true));
            for (i = 0; i < length; ++i) {
                vinepos = pos.func_177968_d().func_177979_c(i);
                if (!world.func_217375_a(vinepos, p -> p.func_177230_c() == Blocks.field_150350_a)) continue;
                world.func_180501_a(vinepos, state, 2);
            }
            length = 3 + rand.nextInt(5);
            state = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(true));
            for (i = 0; i < length; ++i) {
                vinepos = pos.func_177976_e().func_177979_c(i);
                if (!world.func_217375_a(vinepos, p -> p.func_177230_c() == Blocks.field_150350_a)) continue;
                world.func_180501_a(vinepos, state, 2);
            }
            length = 3 + rand.nextInt(5);
            state = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.field_176280_O, (Comparable)Boolean.valueOf(true));
            for (i = 0; i < length; ++i) {
                vinepos = pos.func_177974_f().func_177979_c(i);
                if (!world.func_217375_a(vinepos, p -> p.func_177230_c() == Blocks.field_150350_a)) continue;
                world.func_180501_a(vinepos, state, 2);
            }
        }
    }
}

