/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import projectvibrantjourneys.common.biomes.AspenGroveBiome;
import projectvibrantjourneys.common.biomes.BaobabFieldsBiome;
import projectvibrantjourneys.common.biomes.BorealForestBiome;
import projectvibrantjourneys.common.biomes.BorealPlateauBiome;
import projectvibrantjourneys.common.biomes.CrimsonThicketBiome;
import projectvibrantjourneys.common.biomes.OvergrownSpiresBiome;
import projectvibrantjourneys.common.biomes.PrairieBiome;
import projectvibrantjourneys.common.biomes.RedwoodPeaksBiome;
import projectvibrantjourneys.common.biomes.RedwoodsBiome;
import projectvibrantjourneys.common.biomes.SnowyBorealForestBiome;
import projectvibrantjourneys.common.biomes.VerdantSandsBiome;
import projectvibrantjourneys.common.biomes.WillowWetlandsBiomes;
import projectvibrantjourneys.common.world.surfacebuilders.BorealPlateauSurfaceBuilder;
import projectvibrantjourneys.common.world.surfacebuilders.RedwoodsSurfaceBuilder;
import projectvibrantjourneys.common.world.surfacebuilders.VerdantSandsSurfaceBuilder;
import projectvibrantjourneys.core.PVJConfig;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJBiomes {
    public static Biome overgrown_spires;
    public static Biome verdant_sands;
    public static Biome boreal_forest;
    public static Biome snowy_boreal_forest;
    public static Biome boreal_plateau;
    public static Biome prairie;
    public static Biome willow_wetlands;
    public static Biome redwoods;
    public static Biome redwood_peaks;
    public static Biome baobab_fields;
    public static Biome aspen_grove;
    public static Biome crimson_thicket;
    public static final SurfaceBuilder<SurfaceBuilderConfig> VERDANT_SANDS_SB;
    public static final SurfaceBuilder<SurfaceBuilderConfig> BOREAL_PLATEAU_SB;
    public static final SurfaceBuilder<SurfaceBuilderConfig> REDWOODS_SB;

    @SubscribeEvent
    public static void initBiomes(RegistryEvent.Register<Biome> event) {
        overgrown_spires = PVJBiomes.registerBiome(new OvergrownSpiresBiome(), BiomeManager.BiomeType.WARM, "overgrown_spires", (Integer)PVJConfig.overgrownSpiresWeight.get());
        verdant_sands = PVJBiomes.registerBiome(new VerdantSandsBiome(), BiomeManager.BiomeType.DESERT, "verdant_sands", (Integer)PVJConfig.verdantSandsWeight.get());
        boreal_forest = PVJBiomes.registerBiome(new BorealForestBiome(), BiomeManager.BiomeType.COOL, "boreal_forest", (Integer)PVJConfig.borealForestWeight.get());
        snowy_boreal_forest = PVJBiomes.registerBiome(new SnowyBorealForestBiome(), BiomeManager.BiomeType.ICY, "snowy_boreal_forest", (Integer)PVJConfig.snowyBorealForestWeight.get());
        boreal_plateau = PVJBiomes.registerBiome(new BorealPlateauBiome(), BiomeManager.BiomeType.ICY, "boreal_plateau", (Integer)PVJConfig.borealPlateauWeight.get());
        willow_wetlands = PVJBiomes.registerBiome(new WillowWetlandsBiomes(), BiomeManager.BiomeType.WARM, "willow_wetlands", (Integer)PVJConfig.willowWetlandsWeight.get());
        redwoods = PVJBiomes.registerBiome(new RedwoodsBiome(), BiomeManager.BiomeType.COOL, "redwoods", (Integer)PVJConfig.redwoodsWeight.get());
        redwood_peaks = PVJBiomes.registerBiome(new RedwoodPeaksBiome(), BiomeManager.BiomeType.COOL, "redwood_peaks", (Integer)PVJConfig.redwoodPeaksWeight.get());
        baobab_fields = PVJBiomes.registerBiome(new BaobabFieldsBiome(), BiomeManager.BiomeType.WARM, "baobab_fields", (Integer)PVJConfig.baobabFieldsWeight.get());
        aspen_grove = PVJBiomes.registerBiome(new AspenGroveBiome(), BiomeManager.BiomeType.COOL, "aspen_grove", (Integer)PVJConfig.aspenGroveWeight.get());
        crimson_thicket = PVJBiomes.registerBiome(new CrimsonThicketBiome(), BiomeManager.BiomeType.COOL, "crimson_thicket", (Integer)PVJConfig.crimsonThicketWeight.get());
        prairie = PVJBiomes.registerBiome(new PrairieBiome(), BiomeManager.BiomeType.WARM, "prairie", (Integer)PVJConfig.prairieWeight.get());
    }

    public static Biome registerBiome(Biome biome, BiomeManager.BiomeType type, String name, int weight) {
        biome.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        if (weight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        return biome;
    }

    public static void initBiomeTypes() {
        PVJBiomes.addBiomeTypes(overgrown_spires, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.RARE);
        PVJBiomes.addBiomeTypes(verdant_sands, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        PVJBiomes.addBiomeTypes(boreal_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        PVJBiomes.addBiomeTypes(snowy_boreal_forest, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        PVJBiomes.addBiomeTypes(boreal_plateau, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.PLATEAU);
        PVJBiomes.addBiomeTypes(willow_wetlands, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET);
        PVJBiomes.addBiomeTypes(redwoods, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        PVJBiomes.addBiomeTypes(redwood_peaks, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.MOUNTAIN);
        PVJBiomes.addBiomeTypes(baobab_fields, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        PVJBiomes.addBiomeTypes(aspen_grove, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST);
        PVJBiomes.addBiomeTypes(crimson_thicket, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS);
        PVJBiomes.addBiomeTypes(prairie, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS);
    }

    public static void addBiomeTypes(Biome biome, BiomeDictionary.Type ... types) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
    }

    static {
        VERDANT_SANDS_SB = new VerdantSandsSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
        BOREAL_PLATEAU_SB = new BorealPlateauSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
        REDWOODS_SB = new RedwoodsSurfaceBuilder(SurfaceBuilderConfig::func_215455_a);
    }
}

