/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import projectvibrantjourneys.client.renderers.BansheeRenderer;
import projectvibrantjourneys.client.renderers.ClamRenderer;
import projectvibrantjourneys.client.renderers.FireflyRenderer;
import projectvibrantjourneys.client.renderers.FlyRenderer;
import projectvibrantjourneys.client.renderers.GhostRenderer;
import projectvibrantjourneys.client.renderers.GrizzlyBearRenderer;
import projectvibrantjourneys.client.renderers.HauntRenderer;
import projectvibrantjourneys.client.renderers.IceCubeRenderer;
import projectvibrantjourneys.client.renderers.MawRenderer;
import projectvibrantjourneys.client.renderers.NightmareRenderer;
import projectvibrantjourneys.client.renderers.PVJBoatRenderer;
import projectvibrantjourneys.client.renderers.PhantasmRenderer;
import projectvibrantjourneys.client.renderers.ScarecrowRenderer;
import projectvibrantjourneys.client.renderers.ShadeRenderer;
import projectvibrantjourneys.client.renderers.SkeletalKnightRenderer;
import projectvibrantjourneys.client.renderers.SlugRenderer;
import projectvibrantjourneys.client.renderers.SmallSpiderRenderer;
import projectvibrantjourneys.client.renderers.SnailRenderer;
import projectvibrantjourneys.client.renderers.SpecterRenderer;
import projectvibrantjourneys.client.renderers.StarfishRenderer;
import projectvibrantjourneys.client.renderers.WatcherRenderer;
import projectvibrantjourneys.client.renderers.WraithRenderer;
import projectvibrantjourneys.common.entities.WeightedCropList;
import projectvibrantjourneys.common.entities.item.PVJBoatEntity;
import projectvibrantjourneys.common.entities.monster.BansheeEntity;
import projectvibrantjourneys.common.entities.monster.GhostEntity;
import projectvibrantjourneys.common.entities.monster.HauntEntity;
import projectvibrantjourneys.common.entities.monster.IceCubeEntity;
import projectvibrantjourneys.common.entities.monster.MawEntity;
import projectvibrantjourneys.common.entities.monster.NightmareEntity;
import projectvibrantjourneys.common.entities.monster.PhantasmEntity;
import projectvibrantjourneys.common.entities.monster.ShadeEntity;
import projectvibrantjourneys.common.entities.monster.SkeletalKnightEntity;
import projectvibrantjourneys.common.entities.monster.SpecterEntity;
import projectvibrantjourneys.common.entities.monster.WatcherEntity;
import projectvibrantjourneys.common.entities.monster.WraithEntity;
import projectvibrantjourneys.common.entities.passive.ClamEntity;
import projectvibrantjourneys.common.entities.passive.FireflyEntity;
import projectvibrantjourneys.common.entities.passive.FlyEntity;
import projectvibrantjourneys.common.entities.passive.GrizzlyBearEntity;
import projectvibrantjourneys.common.entities.passive.ScarecrowEntity;
import projectvibrantjourneys.common.entities.passive.SlugEntity;
import projectvibrantjourneys.common.entities.passive.SmallSpiderEntity;
import projectvibrantjourneys.common.entities.passive.SnailEntity;
import projectvibrantjourneys.common.entities.passive.StarfishEntity;
import projectvibrantjourneys.common.entities.projectile.CropShotEntity;
import projectvibrantjourneys.core.PVJConfig;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJEntities {
    public static EntityType<FlyEntity> fly;
    public static EntityType<FireflyEntity> firefly;
    public static EntityType<StarfishEntity> starfish;
    public static EntityType<StarfishEntity> starfish_ocean;
    public static EntityType<ClamEntity> clam;
    public static EntityType<SnailEntity> snail;
    public static EntityType<SlugEntity> slug;
    public static EntityType<SmallSpiderEntity> small_spider;
    public static EntityType<ScarecrowEntity> scarecrow;
    public static EntityType<GhostEntity> ghost;
    public static EntityType<WatcherEntity> watcher;
    public static EntityType<GrizzlyBearEntity> grizzly_bear;
    public static EntityType<SkeletalKnightEntity> skeletal_knight;
    public static EntityType<ShadeEntity> shade;
    public static EntityType<BansheeEntity> banshee;
    public static EntityType<WraithEntity> wraith;
    public static EntityType<SpecterEntity> specter;
    public static EntityType<HauntEntity> haunt;
    public static EntityType<PhantasmEntity> phantasm;
    public static EntityType<NightmareEntity> nightmare;
    public static EntityType<IceCubeEntity> ice_cube;
    public static EntityType<MawEntity> maw;
    public static EntityType<CropShotEntity> crop_shot;
    public static EntityType<PVJBoatEntity> pvj_boat;
    public static final EntityClassification PVJ_AMBIENT;
    public static final EntityClassification PVJ_WATER_AMBIENT;

    @SubscribeEvent
    public static void initEntities(RegistryEvent.Register<EntityType<?>> event) {
        PVJEntities.registerEntity(fly);
        PVJEntities.registerEntity(firefly);
        PVJEntities.registerEntity(starfish);
        PVJEntities.registerEntity(starfish_ocean);
        PVJEntities.registerEntity(clam);
        PVJEntities.registerEntity(snail);
        PVJEntities.registerEntity(slug);
        PVJEntities.registerEntity(small_spider);
        PVJEntities.registerEntity(scarecrow);
        PVJEntities.registerEntity(ghost);
        PVJEntities.registerEntity(watcher);
        PVJEntities.registerEntity(grizzly_bear);
        PVJEntities.registerEntity(skeletal_knight);
        PVJEntities.registerEntity(shade);
        PVJEntities.registerEntity(banshee);
        PVJEntities.registerEntity(wraith);
        PVJEntities.registerEntity(specter);
        PVJEntities.registerEntity(haunt);
        PVJEntities.registerEntity(phantasm);
        PVJEntities.registerEntity(nightmare);
        PVJEntities.registerEntity(ice_cube);
        PVJEntities.registerEntity(maw);
        PVJEntities.registerEntity(crop_shot);
        PVJEntities.registerEntity(pvj_boat);
        PVJEntities.addSpawnPlacements();
        PVJEntities.setupScarecrowCrops();
    }

    public static void preInitEntityTypes() {
        fly = PVJEntities.setupEntity("fly", fly, FlyEntity::new, PVJ_AMBIENT, 64, 0.1f, 0.1f);
        firefly = PVJEntities.setupEntity("firefly", firefly, FireflyEntity::new, PVJ_AMBIENT, 64, 0.1f, 0.1f);
        starfish = PVJEntities.setupEntity("starfish", starfish, StarfishEntity::new, PVJ_AMBIENT, 64, 0.4f, 0.1f);
        starfish_ocean = PVJEntities.setupEntity("starfish_ocean", starfish_ocean, StarfishEntity::new, PVJ_WATER_AMBIENT, 64, 0.4f, 0.1f);
        clam = PVJEntities.setupEntity("clam", clam, ClamEntity::new, PVJ_WATER_AMBIENT, 64, 0.45f, 0.2f);
        snail = PVJEntities.setupEntity("snail", snail, SnailEntity::new, PVJ_AMBIENT, 64, 0.25f, 0.15f);
        slug = PVJEntities.setupEntity("slug", slug, SlugEntity::new, PVJ_AMBIENT, 64, 0.25f, 0.1f);
        small_spider = PVJEntities.setupEntity("small_spider", small_spider, SmallSpiderEntity::new, PVJ_AMBIENT, 64, 0.28f, 0.18f);
        scarecrow = PVJEntities.setupEntity("scarecrow", scarecrow, ScarecrowEntity::new, EntityClassification.MISC, 64, 1.0f, 2.5f);
        ghost = PVJEntities.setupEntity("ghost", ghost, GhostEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        watcher = PVJEntities.setupEntity("watcher", watcher, WatcherEntity::new, EntityClassification.MONSTER, 64, 1.0f, 1.0f);
        grizzly_bear = PVJEntities.setupEntity("grizzly_bear", grizzly_bear, GrizzlyBearEntity::new, EntityClassification.CREATURE, 64, 1.4f, 1.4f);
        skeletal_knight = PVJEntities.setupEntity("skeletal_knight", skeletal_knight, SkeletalKnightEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.99f);
        shade = PVJEntities.setupEntity("shade", shade, ShadeEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        banshee = PVJEntities.setupEntity("banshee", banshee, BansheeEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        wraith = PVJEntities.setupEntity("wraith", wraith, WraithEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        specter = PVJEntities.setupEntity("specter", specter, SpecterEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        haunt = PVJEntities.setupEntity("haunt", haunt, HauntEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        phantasm = PVJEntities.setupEntity("phantasm", phantasm, PhantasmEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        nightmare = PVJEntities.setupEntity("nightmare", nightmare, NightmareEntity::new, EntityClassification.MONSTER, 64, 0.6f, 1.95f);
        ice_cube = PVJEntities.setupEntity("ice_cube", ice_cube, IceCubeEntity::new, EntityClassification.MONSTER, 64, 2.0f, 2.0f);
        maw = PVJEntities.setupEntity("maw", maw, MawEntity::new, EntityClassification.MONSTER, 64, 1.0f, 4.5f);
        crop_shot = PVJEntities.setupEntity("crop_shot", crop_shot, CropShotEntity::new, EntityClassification.MISC, 64, 0.25f, 0.25f);
        pvj_boat = PVJEntities.setupEntity("pvj_boat", pvj_boat, PVJBoatEntity::new, EntityClassification.MISC, 64, 1.375f, 0.5625f);
    }

    public static <T extends Entity> EntityType<T> setupEntity(String name, EntityType<T> entityType, EntityType.IFactory<T> entityTypeFactory, EntityClassification classification, int range, float width, float height) {
        entityType = EntityType.Builder.func_220322_a(entityTypeFactory, (EntityClassification)classification).setTrackingRange(range).func_220321_a(width, height).func_206830_a(name);
        entityType.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        return entityType;
    }

    public static <T extends Entity> void registerEntity(EntityType<T> entityType) {
        ForgeRegistries.ENTITIES.register(entityType);
    }

    private static void addSpawnPlacements() {
        EntitySpawnPlacementRegistry.func_209343_a(fly, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FlyEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(firefly, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FireflyEntity::canSpawnFirefly);
        EntitySpawnPlacementRegistry.func_209343_a(starfish, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StarfishEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(starfish_ocean, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.OCEAN_FLOOR, StarfishEntity::canSpawnOcean);
        EntitySpawnPlacementRegistry.func_209343_a(clam, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ClamEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(snail, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SnailEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(slug, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SlugEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(small_spider, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SmallSpiderEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(ghost, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(watcher, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(grizzly_bear, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GrizzlyBearEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(skeletal_knight, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(shade, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(banshee, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(wraith, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(specter, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(haunt, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(phantasm, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(nightmare, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(ice_cube, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, IceCubeEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(maw, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MawEntity::canSpawn);
    }

    public static void addSpawns() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            PVJEntities.addSpawn(biome, fly, PVJ_AMBIENT, 15, 1, 3, (List)PVJConfig.flyBiomes.get());
            PVJEntities.addSpawn(biome, firefly, PVJ_AMBIENT, 15, 1, 4, (List)PVJConfig.fireflyBiomes.get());
            PVJEntities.addSpawn(biome, starfish, PVJ_AMBIENT, 15, 1, 3, (List)PVJConfig.starfishBiomes.get());
            PVJEntities.addSpawn(biome, starfish_ocean, PVJ_WATER_AMBIENT, 5, 1, 3, (List)PVJConfig.starfishBiomes.get());
            PVJEntities.addSpawn(biome, clam, PVJ_WATER_AMBIENT, 3, 1, 3, (List)PVJConfig.clamBiomes.get());
            PVJEntities.addSpawn(biome, snail, PVJ_AMBIENT, 10, 1, 2, (List)PVJConfig.snailBiomes.get());
            PVJEntities.addSpawn(biome, slug, PVJ_AMBIENT, 10, 1, 2, (List)PVJConfig.slugBiomes.get());
            PVJEntities.addSpawn(biome, small_spider, PVJ_AMBIENT, 3, 1, 1, (List)PVJConfig.smallSpiderBiomes.get());
            PVJEntities.addSpawn(biome, ghost, EntityClassification.MONSTER, 40, 1, 1, (List)PVJConfig.ghostBiomes.get());
            PVJEntities.addSpawn(biome, watcher, EntityClassification.MONSTER, 2, 1, 4, (List)PVJConfig.watcherBiomes.get());
            PVJEntities.addSpawn(biome, grizzly_bear, EntityClassification.CREATURE, 1, 1, 2, (List)PVJConfig.grizzlyBearBiomes.get());
            PVJEntities.addSpawn(biome, skeletal_knight, EntityClassification.MONSTER, 50, 1, 2, (List)PVJConfig.skeletalKnightBiomes.get());
            PVJEntities.addSpawn(biome, shade, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.shadeBiomes.get());
            PVJEntities.addSpawn(biome, banshee, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.bansheeBiomes.get());
            PVJEntities.addSpawn(biome, wraith, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.wraithBiomes.get());
            PVJEntities.addSpawn(biome, haunt, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.hauntBiomes.get());
            PVJEntities.addSpawn(biome, specter, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.specterBiomes.get());
            PVJEntities.addSpawn(biome, phantasm, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.phantasmBiomes.get());
            PVJEntities.addSpawn(biome, nightmare, EntityClassification.MONSTER, 70, 1, 1, (List)PVJConfig.nightmareBiomes.get());
            PVJEntities.addSpawn(biome, ice_cube, EntityClassification.MONSTER, 30, 1, 1, (List)PVJConfig.iceCubeBiomes.get());
            PVJEntities.addSpawn(biome, maw, EntityClassification.MONSTER, 30, 1, 1, (List)PVJConfig.mawBiomes.get());
            PVJEntities.addSpawn(biome, EntityType.field_204262_at, EntityClassification.WATER_CREATURE, 20, 8, 8, (List)PVJConfig.tropicalFishBiomes.get());
        }
        if (((Boolean)PVJConfig.skeletalKnightDungeons.get()).booleanValue()) {
            DungeonHooks.addDungeonMob(skeletal_knight, (int)100);
        }
    }

    private static <T extends Entity> void addSpawn(Biome biome, EntityType<T> entity, EntityClassification creatureType, int weight, int min, int max, List<String> spawnBiomes) {
        if (weight > 0 && min > 0 && max > 0 && !spawnBiomes.isEmpty() && spawnBiomes.contains(biome.getRegistryName().toString())) {
            biome.func_76747_a(creatureType).add(new Biome.SpawnListEntry(entity, weight, min, max));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(fly, FlyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(firefly, FireflyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(starfish, StarfishRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(starfish_ocean, StarfishRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(clam, ClamRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(snail, SnailRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(slug, SlugRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(small_spider, SmallSpiderRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(scarecrow, ScarecrowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ghost, GhostRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(watcher, WatcherRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(grizzly_bear, GrizzlyBearRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(skeletal_knight, SkeletalKnightRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(shade, ShadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(banshee, BansheeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(wraith, WraithRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(specter, SpecterRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(haunt, HauntRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(phantasm, PhantasmRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(nightmare, NightmareRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ice_cube, IceCubeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(maw, MawRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(crop_shot, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(pvj_boat, PVJBoatRenderer::new);
    }

    public static void setupScarecrowCrops() {
        ScarecrowEntity.crops.addEntry(WeightedCropList.WeightedCropItem.create(Items.field_151015_O, 10), WeightedCropList.WeightedCropItem.create(Items.field_151014_N, 10), WeightedCropList.WeightedCropItem.create(Items.field_151172_bF, 10), WeightedCropList.WeightedCropItem.create(Items.field_151174_bG, 10), WeightedCropList.WeightedCropItem.create(Items.field_185164_cV, 10), WeightedCropList.WeightedCropItem.create(Items.field_185163_cU, 10), WeightedCropList.WeightedCropItem.create(Items.field_222112_pR, 10), WeightedCropList.WeightedCropItem.create(Items.field_151080_bb, 10), WeightedCropList.WeightedCropItem.create(Items.field_151034_e, 10), WeightedCropList.WeightedCropItem.create(Items.field_221687_cF, 5), WeightedCropList.WeightedCropItem.create(Items.field_221794_dg, 5), WeightedCropList.WeightedCropItem.create(Items.field_151127_ba, 10), WeightedCropList.WeightedCropItem.create(Items.field_222065_kN, 10), WeightedCropList.WeightedCropItem.create(Items.field_221774_cw, 5), WeightedCropList.WeightedCropItem.create(Items.field_151170_bI, 5));
    }

    static {
        PVJ_AMBIENT = EntityClassification.create((String)"pvj_ambient", (String)"pvj_ambient", (int)40, (boolean)true, (boolean)false);
        PVJ_WATER_AMBIENT = EntityClassification.create((String)"pvj_water_ambient", (String)"pvj_water_ambient", (int)15, (boolean)true, (boolean)false);
    }
}

