/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.init;

import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import projectvibrantjourneys.common.world.features.BarkMushroomFeature;
import projectvibrantjourneys.common.world.features.BushFeature;
import projectvibrantjourneys.common.world.features.CobwebFeature;
import projectvibrantjourneys.common.world.features.FallenTreeFeature;
import projectvibrantjourneys.common.world.features.MangroveRootsFeature;
import projectvibrantjourneys.common.world.features.OceanFloorSeashellsFeature;
import projectvibrantjourneys.common.world.features.WaterCattailFeature;
import projectvibrantjourneys.common.world.features.trees.AspenTreeFeature;
import projectvibrantjourneys.common.world.features.trees.BaobabTreeFeature;
import projectvibrantjourneys.common.world.features.trees.CottonwoodTreeFeature;
import projectvibrantjourneys.common.world.features.trees.JuniperTreeFeature;
import projectvibrantjourneys.common.world.features.trees.MangroveTreeFeature;
import projectvibrantjourneys.common.world.features.trees.MegaRedwoodTreeFeature;
import projectvibrantjourneys.common.world.features.trees.PalmTreeFeature;
import projectvibrantjourneys.common.world.features.trees.PineTreeFeature;
import projectvibrantjourneys.common.world.features.trees.RedwoodTreeFeature;
import projectvibrantjourneys.common.world.features.trees.WillowTreeFeature;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJFeatures {
    public static Feature<SeaGrassConfig> oceanFloorSeashellsFeature;
    public static Feature<ProbabilityConfig> bushFeature;
    public static Feature<SeaGrassConfig> waterCattailFeature;
    public static Feature<NoFeatureConfig> barkMushroomFeature;
    public static Feature<NoFeatureConfig> cobwebFeature;
    public static Feature<BlockStateFeatureConfig> fallenTreeFeature;
    public static Feature<BlockClusterFeatureConfig> randomPatchNoFlatFeature;
    public static Feature<TreeFeatureConfig> pineTree;
    public static Feature<TreeFeatureConfig> palmTree;
    public static Feature<TreeFeatureConfig> willowTree;
    public static Feature<TreeFeatureConfig> mangroveTree;
    public static Feature<TreeFeatureConfig> redwoodTree;
    public static Feature<TreeFeatureConfig> aspenTree;
    public static Feature<HugeTreeFeatureConfig> megaRedwoodTree;
    public static Feature<HugeTreeFeatureConfig> baobabTree;
    public static Feature<TreeFeatureConfig> cottonwoodTree;
    public static Feature<TreeFeatureConfig> juniperTree;
    public static Feature<NoFeatureConfig> mangroveRootFeature;

    @SubscribeEvent
    public static void initFeatures(RegistryEvent.Register<Feature<?>> event) {
        oceanFloorSeashellsFeature = new OceanFloorSeashellsFeature(SeaGrassConfig::func_214659_a);
        bushFeature = new BushFeature(ProbabilityConfig::func_214645_a);
        waterCattailFeature = new WaterCattailFeature(SeaGrassConfig::func_214659_a);
        barkMushroomFeature = new BarkMushroomFeature(NoFeatureConfig::func_214639_a);
        cobwebFeature = new CobwebFeature(NoFeatureConfig::func_214639_a);
        fallenTreeFeature = new FallenTreeFeature(BlockStateFeatureConfig::func_227271_a_);
        pineTree = new PineTreeFeature(TreeFeatureConfig::func_227338_a_);
        palmTree = new PalmTreeFeature(TreeFeatureConfig::func_227338_a_);
        willowTree = new WillowTreeFeature(TreeFeatureConfig::func_227338_a_);
        mangroveTree = new MangroveTreeFeature(TreeFeatureConfig::func_227338_a_);
        redwoodTree = new RedwoodTreeFeature(TreeFeatureConfig::func_227338_a_);
        aspenTree = new AspenTreeFeature(TreeFeatureConfig::func_227338_a_);
        megaRedwoodTree = new MegaRedwoodTreeFeature(HugeTreeFeatureConfig::func_227277_a_);
        baobabTree = new BaobabTreeFeature(HugeTreeFeatureConfig::func_227277_a_);
        cottonwoodTree = new CottonwoodTreeFeature(TreeFeatureConfig::func_227338_a_);
        juniperTree = new JuniperTreeFeature(TreeFeatureConfig::func_227338_a_);
        mangroveRootFeature = new MangroveRootsFeature(NoFeatureConfig::func_214639_a);
        PVJFeatures.registerFeature(oceanFloorSeashellsFeature, "ocean_floor_seashells_feature");
        PVJFeatures.registerFeature(bushFeature, "bush_feature");
        PVJFeatures.registerFeature(waterCattailFeature, "water_cattail_feature");
        PVJFeatures.registerFeature(barkMushroomFeature, "bark_mushroom_feature");
        PVJFeatures.registerFeature(cobwebFeature, "cobweb_feature");
        PVJFeatures.registerFeature(fallenTreeFeature, "fallen_tree_feature");
        PVJFeatures.registerFeature(pineTree, "pine_tree");
        PVJFeatures.registerFeature(palmTree, "palm_tree");
        PVJFeatures.registerFeature(willowTree, "willow_tree");
        PVJFeatures.registerFeature(mangroveTree, "mangrove_tree");
        PVJFeatures.registerFeature(redwoodTree, "redwood_tree");
        PVJFeatures.registerFeature(aspenTree, "aspen_tree");
        PVJFeatures.registerFeature(megaRedwoodTree, "mega_redwood_tree");
        PVJFeatures.registerFeature(baobabTree, "baobab_tree");
        PVJFeatures.registerFeature(cottonwoodTree, "cottonwood_tree");
        PVJFeatures.registerFeature(juniperTree, "juniper_tree");
        PVJFeatures.registerFeature(mangroveRootFeature, "mangrove_root_feature");
    }

    public static void registerFeature(Feature<?> feature, String name) {
        feature.setRegistryName(new ResourceLocation("projectvibrantjourneys", name));
        ForgeRegistries.FEATURES.register(feature);
    }
}

