/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore;

import net.minecraftforge.common.ForgeConfigSpec;

public class ThreeCoreCommonConfig {
    public static Materials MATERIALS;

    public static ForgeConfigSpec generateConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        MATERIALS = new Materials(builder);
        return builder.build();
    }

    public static class Materials {
        public OreConfig COPPER;
        public OreConfig TIN;
        public OreConfig LEAD;
        public OreConfig SILVER;
        public OreConfig PALLADIUM;
        public OreConfig VIBRANIUM;
        public OreConfig OSMIUM;
        public OreConfig URANIUM;
        public OreConfig TITANIUM;
        public OreConfig IRIDIUM;
        public OreConfig URU;

        private Materials(ForgeConfigSpec.Builder builder) {
            builder.comment("ThreeCore base settings").push("base");
            this.COPPER = this.makeOreConfig(builder, "copper", 8, 8, 40, 75);
            this.TIN = this.makeOreConfig(builder, "tin", 8, 7, 20, 55);
            this.LEAD = this.makeOreConfig(builder, "lead", 8, 4, 10, 35);
            this.SILVER = this.makeOreConfig(builder, "silver", 8, 4, 5, 30);
            this.PALLADIUM = this.makeOreConfig(builder, "palladium", 6, 3, 10, 25);
            this.VIBRANIUM = this.makeOreConfig(builder, "vibranium", 3, 1, 0, 16);
            this.OSMIUM = this.makeOreConfig(builder, "osmium", 8, 4, 10, 40);
            this.URANIUM = this.makeOreConfig(builder, "uranium", 2, 5, 10, 25);
            this.TITANIUM = this.makeOreConfig(builder, "titanium", 3, 2, 0, 16);
            this.IRIDIUM = this.makeOreConfig(builder, "iridium", 3, 1, 0, 16);
            this.URU = this.makeOreConfig(builder, "uru", 3, 1, 0, 16);
            builder.pop();
        }

        public OreConfig makeOreConfig(ForgeConfigSpec.Builder builder, String ore, int defaultSize, int defaultCount, int defaultMinHeight, int defaultMaxHeight) {
            ForgeConfigSpec.ConfigValue size = builder.define("ore." + ore + ".size", (Object)defaultSize);
            ForgeConfigSpec.ConfigValue count = builder.define("ore." + ore + ".count", (Object)defaultCount);
            ForgeConfigSpec.ConfigValue minHeight = builder.define("ore." + ore + ".minHeight", (Object)defaultMinHeight);
            ForgeConfigSpec.ConfigValue maxHeight = builder.define("ore." + ore + ".maxHeight", (Object)defaultMaxHeight);
            return new OreConfig((ForgeConfigSpec.ConfigValue<Integer>)size, (ForgeConfigSpec.ConfigValue<Integer>)count, (ForgeConfigSpec.ConfigValue<Integer>)minHeight, (ForgeConfigSpec.ConfigValue<Integer>)maxHeight);
        }

        public static class OreConfig {
            public ForgeConfigSpec.ConfigValue<Integer> size;
            public ForgeConfigSpec.ConfigValue<Integer> count;
            public ForgeConfigSpec.ConfigValue<Integer> minHeight;
            public ForgeConfigSpec.ConfigValue<Integer> maxHeight;

            public OreConfig(ForgeConfigSpec.ConfigValue<Integer> size, ForgeConfigSpec.ConfigValue<Integer> count, ForgeConfigSpec.ConfigValue<Integer> minHeight, ForgeConfigSpec.ConfigValue<Integer> maxHeight) {
                this.size = size;
                this.count = count;
                this.minHeight = minHeight;
                this.maxHeight = maxHeight;
            }
        }
    }
}

