/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.EnumAbilityColor;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.ability.condition.AbilityConditionManager;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.ability.AbilityScreen;
import net.threetag.threecore.scripts.events.AbilityDataUpdatedScriptEvent;
import net.threetag.threecore.scripts.events.AbilityTickScriptEvent;
import net.threetag.threecore.util.RenderUtil;
import net.threetag.threecore.util.icon.IIcon;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.threedata.AbilityColorThreeData;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.CompoundNBTThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.IWrappedThreeDataHolder;
import net.threetag.threecore.util.threedata.IconThreeData;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.TextComponentThreeData;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.ThreeDataManager;

public abstract class Ability
implements INBTSerializable<CompoundNBT>,
IWrappedThreeDataHolder {
    public static final ThreeData<Boolean> SHOW_IN_BAR = new BooleanThreeData("show_in_bar").setSyncType(EnumSync.SELF).enableSetting("show_in_bar", "Determines if this ability should be displayed in the ability bar without a condition that displays it there.");
    public static final ThreeData<Boolean> HIDDEN = new BooleanThreeData("hidden").setSyncType(EnumSync.SELF).enableSetting("If enabled, the ability will be invisible for the ability GUI & ability bar");
    public static final ThreeData<ITextComponent> TITLE = new TextComponentThreeData("title").setSyncType(EnumSync.SELF).enableSetting("title", "Allows you to set a custom title for this ability");
    public static final ThreeData<IIcon> ICON = new IconThreeData("icon").setSyncType(EnumSync.SELF).enableSetting("icon", "Lets you customize the icon for the ability");
    public static final ThreeData<Integer> KEYBIND = new IntegerThreeData("key").setSyncType(EnumSync.SELF);
    public static final ThreeData<EnumAbilityColor> COLOR = new AbilityColorThreeData("bar_color").setSyncType(EnumSync.SELF).enableSetting("Changes the color of the ability in the ability bar");
    public static final ThreeData<CompoundNBT> ADDITIONAL_DATA = new CompoundNBTThreeData("additional_data").enableSetting("You can store additional data here, especially useful if you use scripts and want to mark certain abilities");
    public final AbilityType type;
    String id;
    public EnumSync sync = EnumSync.NONE;
    public IAbilityContainer container;
    protected ThreeDataManager dataManager = new ThreeDataManager().setListener(new ThreeDataManager.Listener(){

        @Override
        public <T> void dataChanged(ThreeData<T> data, T oldValue, T value) {
            Ability.this.sync = Ability.this.sync.add(data.getSyncType());
            Ability.this.setDirty();
            if (Ability.this.entity != null) {
                new AbilityDataUpdatedScriptEvent(Ability.this.entity, Ability.this, data.getKey(), value, oldValue).fire();
            }
        }
    });
    protected AbilityConditionManager conditionManager = new AbilityConditionManager(this);
    protected int ticks = 0;
    public boolean dirty = false;
    public LivingEntity entity;

    public Ability(AbilityType type) {
        this.type = type;
        this.registerData();
    }

    public void readFromJson(JsonObject jsonObject) {
        this.dataManager.readFromJson(jsonObject);
        this.conditionManager.readFromJson(jsonObject);
    }

    public void registerData() {
        this.dataManager.register((ThreeData)SHOW_IN_BAR, (Object)false);
        this.dataManager.register((ThreeData)HIDDEN, (Object)this.isEffect());
        this.dataManager.register((ThreeData)TITLE, new TranslationTextComponent("ability." + this.type.getRegistryName().func_110624_b() + "." + this.type.getRegistryName().func_110623_a()));
        this.dataManager.register((ThreeData)ICON, new ItemIcon((IItemProvider)Blocks.field_180401_cv));
        this.dataManager.register((ThreeData)KEYBIND, (Object)-1);
        this.dataManager.register((ThreeData)COLOR, (Object)EnumAbilityColor.LIGHT_GRAY);
        this.dataManager.register((ThreeData)ADDITIONAL_DATA, new CompoundNBT());
    }

    public CompoundNBT getAdditionalData() {
        return ((CompoundNBT)this.get(ADDITIONAL_DATA)).func_74737_b();
    }

    public Ability setAdditionalData(CompoundNBT nbt) {
        this.set(ADDITIONAL_DATA, nbt);
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawIcon(Minecraft mc, MatrixStack stack, AbstractGui gui, int x, int y) {
        RenderUtil.setCurrentAbilityInIconRendering(this);
        if (this.getDataManager().has((ThreeData)ICON)) {
            this.getDataManager().get(ICON).draw(mc, stack, x, y);
        }
    }

    public boolean isEffect() {
        return false;
    }

    public void tick(LivingEntity entity) {
        this.entity = entity;
        this.conditionManager.update(entity);
        if (this.conditionManager.isEnabled()) {
            if (this.ticks == 0) {
                this.conditionManager.firstTick();
                this.firstTick(entity);
            }
            ++this.ticks;
            this.action(entity);
        } else if (this.ticks != 0) {
            this.lastTick(entity);
            this.conditionManager.lastTick();
            this.ticks = 0;
        }
        new AbilityTickScriptEvent(entity, this).fire();
    }

    public void action(LivingEntity entity) {
        this.updateTick(entity);
    }

    @Deprecated
    public void updateTick(LivingEntity entity) {
    }

    public void firstTick(LivingEntity entity) {
    }

    public void lastTick(LivingEntity entity) {
    }

    public ThreeDataManager getDataManager() {
        return this.dataManager;
    }

    public AbilityConditionManager getConditionManager() {
        return this.conditionManager;
    }

    public final String getId() {
        return this.id;
    }

    public final String getExtendedId() {
        return this.getContainer().getId().toString() + "#" + this.getId();
    }

    public final IAbilityContainer getContainer() {
        return this.container;
    }

    @Override
    public IThreeDataHolder getThreeDataHolder() {
        return this.dataManager;
    }

    public void setDirty() {
        this.dirty = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumAbilityColor getColor() {
        return (EnumAbilityColor)((Object)this.get(COLOR));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("AbilityType", this.type.getRegistryName().toString());
        nbt.func_218657_a("Data", (INBT)this.dataManager.serializeNBT());
        nbt.func_218657_a("Conditions", (INBT)this.conditionManager.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dataManager.deserializeNBT(nbt.func_74775_l("Data"));
        this.conditionManager.deserializeNBT(nbt.func_74775_l("Conditions"));
    }

    public CompoundNBT getUpdateTag() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("AbilityType", this.type.getRegistryName().toString());
        nbt.func_218657_a("Data", (INBT)this.dataManager.getUpdatePacket());
        nbt.func_218657_a("Conditions", (INBT)this.conditionManager.getUpdatePacket());
        return nbt;
    }

    public void readUpdateTag(CompoundNBT nbt) {
        this.dataManager.readUpdatePacket(nbt.func_74775_l("Data"));
        this.conditionManager.readUpdatePacket(nbt.func_74775_l("Conditions"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen getScreen(AbilitiesScreen screen) {
        for (Condition c : this.getConditionManager().getConditions()) {
            Screen s = c.getScreen(screen);
            if (s == null) continue;
            return s;
        }
        return new AbilityScreen(this, screen);
    }
}

