/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.CustomHotbarAbility;
import net.threetag.threecore.ability.EnergyAbility;
import net.threetag.threecore.ability.HUDAbility;
import net.threetag.threecore.ability.InvisibilityAbility;
import net.threetag.threecore.ability.MultiJumpAbility;
import net.threetag.threecore.ability.NameChangeAbility;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.widget.TranslucentButton;
import net.threetag.threecore.client.renderer.AbilityBarRenderer;
import net.threetag.threecore.client.settings.AbilityKeyBinding;
import net.threetag.threecore.network.AbilityKeyMessage;
import net.threetag.threecore.network.MultiJumpMessage;

public class AbilityClientEventHandler {
    public static final String CATEGORY = "ThreeCore";
    public static final KeyBinding SCROLL_UP = new KeyBinding("key.threecore.scroll_up", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 73, "ThreeCore");
    public static final KeyBinding SCROLL_DOWN = new KeyBinding("key.threecore.scroll_down", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 80, "ThreeCore");
    public static List<AbilityKeyBinding> ABILITY_KEYS = Lists.newArrayList();
    public static Map<Integer, Boolean> KEY_STATE = Maps.newHashMap();

    public AbilityClientEventHandler() {
        if (Minecraft.func_71410_x() != null) {
            ClientRegistry.registerKeyBinding((KeyBinding)SCROLL_UP);
            ClientRegistry.registerKeyBinding((KeyBinding)SCROLL_DOWN);
            for (int i = 1; i <= 5; ++i) {
                AbilityKeyBinding keyBinding = new AbilityKeyBinding("key.threecore.ability_" + i, (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, i == 1 ? 86 : (i == 2 ? 66 : (i == 3 ? 78 : (i == 4 ? 77 : (i == 5 ? 44 : -1)))), i, CATEGORY);
                ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
                ABILITY_KEYS.add(keyBinding);
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent e) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        if (e.getAction() < 2) {
            List<Object> abilities = AbilityHelper.getAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g).stream().filter(a -> a.getConditionManager().isUnlocked() && a.getConditionManager().needsKey() && a.getDataManager().get(Ability.KEYBIND) > -1).collect(Collectors.toList());
            for (Ability ability : abilities) {
                if (ability == null || ability.getContainer() == null || ability.getDataManager().get(Ability.KEYBIND).intValue() != e.getKey()) continue;
                if (!KEY_STATE.containsKey(e.getKey())) {
                    KEY_STATE.put(e.getKey(), false);
                }
                if (KEY_STATE.get(e.getKey()) != (e.getAction() == 1)) {
                    ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new AbilityKeyMessage(ability.getContainer().getId(), ability.getId(), e.getAction() == 1));
                }
                KEY_STATE.put(e.getKey(), e.getAction() == 1);
            }
            abilities = AbilityBarRenderer.getCurrentDisplayedAbilities(AbilityHelper.getAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g));
            for (AbilityKeyBinding abilityKeyBinding : ABILITY_KEYS) {
                Ability ability;
                if (e.getKey() != abilityKeyBinding.getKey().func_197937_c()) continue;
                if (!KEY_STATE.containsKey(e.getKey())) {
                    KEY_STATE.put(e.getKey(), false);
                }
                if (abilityKeyBinding.index > abilities.size() || (ability = (Ability)abilities.get(abilityKeyBinding.index - 1)) == null || ability.getContainer() == null || KEY_STATE.get(e.getKey()) == (e.getAction() == 1)) continue;
                ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new AbilityKeyMessage(ability.getContainer().getId(), ability.getId(), e.getAction() == 1));
                KEY_STATE.put(e.getKey(), e.getAction() == 1);
            }
        }
        if (SCROLL_UP.func_151470_d()) {
            AbilityBarRenderer.scroll(true);
        } else if (SCROLL_DOWN.func_151470_d()) {
            AbilityBarRenderer.scroll(false);
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_() && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && !Minecraft.func_71410_x().field_71439_g.func_233570_aj_()) {
            for (MultiJumpAbility ability : AbilityHelper.getAbilitiesFromClass((LivingEntity)Minecraft.func_71410_x().field_71439_g, MultiJumpAbility.class)) {
                if (!ability.getConditionManager().isEnabled()) continue;
                ThreeCore.NETWORK_CHANNEL.sendToServer((Object)new MultiJumpMessage(ability.container.getId(), ability.getId()));
            }
        }
    }

    @SubscribeEvent
    public void onMouse(GuiScreenEvent.MouseScrollEvent.Pre e) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_213453_ef() && e.getScrollDelta() != 0.0) {
            AbilityBarRenderer.scroll(e.getScrollDelta() > 0.0);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent e) {
        if (e.getGui() instanceof ChatScreen) {
            e.addWidget((Widget)new TranslucentButton(e.getGui().field_230708_k_ - 1 - 75, e.getGui().field_230709_l_ - 40, 75, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.threecore.abilities", (Object[])new Object[0])), b -> Minecraft.func_71410_x().func_147108_a((Screen)new AbilitiesScreen())));
        }
        for (Integer i : KEY_STATE.keySet()) {
            KEY_STATE.put(i, false);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre e) {
        for (InvisibilityAbility invisibilityAbility : AbilityHelper.getAbilitiesFromClass(e.getEntity(), InvisibilityAbility.class)) {
            if (!invisibilityAbility.getConditionManager().isEnabled()) continue;
            e.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderNameplateEvent e) {
        if (e.getEntity() instanceof LivingEntity && !(e.getEntity() instanceof ArmorStandEntity)) {
            for (NameChangeAbility ability : AbilityHelper.getAbilitiesFromClass((LivingEntity)e.getEntity(), NameChangeAbility.class)) {
                if (!ability.getConditionManager().isEnabled()) continue;
                if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                    e.setContent((ITextComponent)new StringTextComponent(((ITextComponent)ability.get(NameChangeAbility.NAME)).getString() + " (" + e.getOriginalContent() + ")"));
                } else {
                    e.setContent((ITextComponent)ability.get(NameChangeAbility.NAME));
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onHeartsPre(RenderGameOverlayEvent.Pre e) {
        for (CustomHotbarAbility ability : AbilityHelper.getAbilitiesFromClass((LivingEntity)Minecraft.func_71410_x().field_71439_g, CustomHotbarAbility.class)) {
            if (!ability.getConditionManager().isEnabled() || e.getType() != ability.getDataManager().get(CustomHotbarAbility.HOTBAR_ELEMENT)) continue;
            AbstractGui.field_230665_h_ = ability.getDataManager().get(CustomHotbarAbility.TEXTURE);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        }
    }

    @SubscribeEvent
    public void onHeartsPost(RenderGameOverlayEvent.Post e) {
        List<Ability> abilities = AbilityHelper.getAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        for (CustomHotbarAbility customHotbarAbility : AbilityHelper.getAbilitiesFromClass(abilities, CustomHotbarAbility.class)) {
            if (!customHotbarAbility.getConditionManager().isEnabled() || e.getType() != customHotbarAbility.getDataManager().get(CustomHotbarAbility.HOTBAR_ELEMENT)) continue;
            AbstractGui.field_230665_h_ = new ResourceLocation("textures/gui/icons.png");
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        }
        if (e.getType() == RenderGameOverlayEvent.ElementType.HELMET && Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a()) {
            for (HUDAbility hUDAbility : AbilityHelper.getAbilitiesFromClass(abilities, HUDAbility.class)) {
                if (!hUDAbility.getConditionManager().isEnabled()) continue;
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.defaultBlendFunc();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableAlphaTest();
                Minecraft.func_71410_x().func_110434_K().func_110577_a((ResourceLocation)hUDAbility.get(HUDAbility.TEXTURE));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_225582_a_(0.0, (double)e.getWindow().func_198087_p(), -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)e.getWindow().func_198107_o(), (double)e.getWindow().func_198087_p(), -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)e.getWindow().func_198107_o(), 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.enableAlphaTest();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (e.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            for (EnergyAbility energyAbility : AbilityHelper.getAbilitiesFromClass(abilities, EnergyAbility.class)) {
                if (!energyAbility.getConditionManager().isUnlocked()) continue;
                Minecraft mc = Minecraft.func_71410_x();
                Integer[] energy_data = energyAbility.dataManager.get(EnergyAbility.ENERGY_TEXTURE_INFO);
                Integer[] base_data = energyAbility.dataManager.get(EnergyAbility.BASE_TEXTURE_INFO);
                double energy = energyAbility.dataManager.get(EnergyAbility.AMOUNT).intValue();
                double max = energyAbility.dataManager.get(EnergyAbility.MAX_AMOUNT).intValue();
                int scaledWidth = e.getWindow().func_198107_o();
                int scaledHeight = e.getWindow().func_198087_p();
                mc.func_110434_K().func_110577_a(energyAbility.dataManager.get(EnergyAbility.BASE_TEXTURE));
                int baseX = base_data[0] >= 0 ? base_data[0] : scaledWidth + base_data[0];
                int baseY = base_data[1] >= 0 ? base_data[1] : scaledHeight + base_data[1];
                mc.field_71456_v.func_238474_b_(e.getMatrixStack(), baseX, baseY, 0, 0, base_data[2].intValue(), base_data[3].intValue());
                mc.func_110434_K().func_110577_a(energyAbility.dataManager.get(EnergyAbility.ENERGY_TEXTURE));
                int energyX = energy_data[0] > 0 ? energy_data[0] : scaledWidth + energy_data[0];
                int energyY = energy_data[1] > 0 ? energy_data[1] : scaledHeight + energy_data[1];
                int energyWidth = energy_data[2] + (int)((double)(Math.abs(energy_data[4]) - energy_data[2]) * (energy / max));
                int energyHeight = energy_data[3] + (int)((double)(Math.abs(energy_data[5]) - energy_data[3]) * (energy / max));
                int energyU = energy_data[4] > 0 ? 0 : Math.abs(energy_data[4]) - energyWidth;
                int energyV = energy_data[5] > 0 ? 0 : Math.abs(energy_data[5]) - energyHeight;
                energyX = energy_data[4] >= 0 ? energyX : energyX + Math.abs(energy_data[4]) - energyWidth;
                energyY = energy_data[5] >= 0 ? energyY : energyY + Math.abs(energy_data[5]) - energyHeight;
                mc.field_71456_v.func_238474_b_(e.getMatrixStack(), energyX, energyY, energyU, energyV, energyWidth, energyHeight);
            }
        }
    }
}

