/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AcceleratingFlightAbility;
import net.threetag.threecore.ability.AttributeModifierAbility;
import net.threetag.threecore.ability.ChangeAbilityTabTextureAbility;
import net.threetag.threecore.ability.CommandAbility;
import net.threetag.threecore.ability.CustomHotbarAbility;
import net.threetag.threecore.ability.DamageImmunityAbility;
import net.threetag.threecore.ability.DummyAbility;
import net.threetag.threecore.ability.EnergyAbility;
import net.threetag.threecore.ability.FlightAbility;
import net.threetag.threecore.ability.HUDAbility;
import net.threetag.threecore.ability.HealingAbility;
import net.threetag.threecore.ability.HideBodyPartsAbility;
import net.threetag.threecore.ability.InvisibilityAbility;
import net.threetag.threecore.ability.ModelLayerAbility;
import net.threetag.threecore.ability.MultiJumpAbility;
import net.threetag.threecore.ability.NameChangeAbility;
import net.threetag.threecore.ability.OpeningNbtTimerAbility;
import net.threetag.threecore.ability.PotionEffectAbility;
import net.threetag.threecore.ability.ProjectileAbility;
import net.threetag.threecore.ability.SizeChangeAbility;
import net.threetag.threecore.ability.SkinChangeAbility;
import net.threetag.threecore.ability.SlowfallAbility;
import net.threetag.threecore.ability.TeleportAbility;
import net.threetag.threecore.ability.WaterBreathingAbility;
import net.threetag.threecore.scripts.events.RegisterAbilityThreeDataScriptEvent;
import net.threetag.threecore.util.threedata.ThreeData;

@Mod.EventBusSubscriber(modid="threecore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AbilityType
extends ForgeRegistryEntry<AbilityType> {
    public static IForgeRegistry<AbilityType> REGISTRY;
    public static final AbilityType DUMMY;
    public static final AbilityType COMMAND;
    public static final AbilityType HEALING;
    public static final AbilityType FLIGHT;
    public static final AbilityType ACCELERATING_FLIGHT;
    public static final AbilityType TELEPORT;
    public static final AbilityType ATTRIBUTE_MODIFIER;
    public static final AbilityType INVISIBILITY;
    public static final AbilityType SLOWFALL;
    public static final AbilityType WATER_BREATHING;
    public static final AbilityType SIZE_CHANGE;
    public static final AbilityType CUSTOM_HOTBAR;
    public static final AbilityType OPENING_NBT_TIMER;
    public static final AbilityType MODEL_LAYER;
    public static final AbilityType PROJECTILE;
    public static final AbilityType DAMAGE_IMMUNITY;
    public static final AbilityType POTION_EFFECT;
    public static final AbilityType MULTI_JUMP;
    public static final AbilityType NAME_CHANGE;
    public static final AbilityType HUD;
    public static final AbilityType SKIN_CHANGE;
    public static final AbilityType HIDE_BODY_PARTS;
    public static final AbilityType CHANGE_ABILITY_TAB_TEXTURE;
    public static final AbilityType ENERGY;
    private Supplier<Ability> supplier;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("threecore", "ability_types")).setType(AbilityType.class).setIDRange(0, 2048).create();
    }

    @SubscribeEvent
    public static void onRegisterAbilityTypes(RegistryEvent.Register<AbilityType> e) {
        e.getRegistry().register((IForgeRegistryEntry)DUMMY);
        e.getRegistry().register((IForgeRegistryEntry)COMMAND);
        e.getRegistry().register((IForgeRegistryEntry)HEALING);
        e.getRegistry().register((IForgeRegistryEntry)FLIGHT);
        e.getRegistry().register((IForgeRegistryEntry)ACCELERATING_FLIGHT);
        e.getRegistry().register((IForgeRegistryEntry)TELEPORT);
        e.getRegistry().register((IForgeRegistryEntry)ATTRIBUTE_MODIFIER);
        e.getRegistry().register((IForgeRegistryEntry)INVISIBILITY);
        e.getRegistry().register((IForgeRegistryEntry)SLOWFALL);
        e.getRegistry().register((IForgeRegistryEntry)WATER_BREATHING);
        e.getRegistry().register((IForgeRegistryEntry)SIZE_CHANGE);
        e.getRegistry().register((IForgeRegistryEntry)CUSTOM_HOTBAR);
        e.getRegistry().register((IForgeRegistryEntry)OPENING_NBT_TIMER);
        e.getRegistry().register((IForgeRegistryEntry)MODEL_LAYER);
        e.getRegistry().register((IForgeRegistryEntry)PROJECTILE);
        e.getRegistry().register((IForgeRegistryEntry)DAMAGE_IMMUNITY);
        e.getRegistry().register((IForgeRegistryEntry)POTION_EFFECT);
        e.getRegistry().register((IForgeRegistryEntry)MULTI_JUMP);
        e.getRegistry().register((IForgeRegistryEntry)NAME_CHANGE);
        e.getRegistry().register((IForgeRegistryEntry)HUD);
        e.getRegistry().register((IForgeRegistryEntry)SKIN_CHANGE);
        e.getRegistry().register((IForgeRegistryEntry)HIDE_BODY_PARTS);
        e.getRegistry().register((IForgeRegistryEntry)CHANGE_ABILITY_TAB_TEXTURE);
        e.getRegistry().register((IForgeRegistryEntry)ENERGY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateHtmlFile(File file) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("<html><head><title>Abilities</title><style>\ntable{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}\n</style><link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"https://i.imgur.com/am80ox1.png\"></head><body>");
            ArrayList<Ability> abilities = new ArrayList<Ability>();
            HashMap<String, List> sorted = new HashMap<String, List>();
            for (AbilityType types : REGISTRY.getValues()) {
                Ability ability = types.create("");
                abilities.add(ability);
                String modName = AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()) != null ? AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()).getDisplayName() : types.getRegistryName().func_110624_b();
                List<Ability> modsAbilities = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
                modsAbilities.add(ability);
                sorted.put(modName, modsAbilities);
            }
            sorted.forEach((s, l) -> {
                try {
                    bw.write("<h1>" + s + "</h1>\n");
                    bw.write("<ul>\n");
                    for (Ability ability : l) {
                        bw.write("<li><a href=\"#" + ability.type.getRegistryName().toString() + "\">" + StringUtils.func_76338_a((String)ability.dataManager.get(Ability.TITLE).getString()) + "</a></li>\n");
                    }
                    bw.write("</ul>\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            bw.write("\n");
            for (Ability ability : abilities) {
                String s2;
                AbilityType entry = ability.type;
                bw.write("<hr>\n");
                bw.write("<p><h1 id=\"" + entry.getRegistryName().toString() + "\">" + StringUtils.func_76338_a((String)ability.dataManager.get(Ability.TITLE).getString()) + "</h1>\n");
                bw.write("<h3>" + entry.getRegistryName().toString() + "</h3>\n");
                List<ThreeData<?>> dataList = ability.getDataManager().getSettingData();
                bw.write("<p>Example:<br>\n");
                StringBuilder jsonText = new StringBuilder("{\"example_ability\":{\"ability\":\"").append(entry.getRegistryName().toString()).append("\",");
                for (int i = 0; i < dataList.size(); ++i) {
                    ThreeData<?> threeData = dataList.get(i);
                    s2 = threeData.getJsonString(ability.getDataManager().getDefaultValue(threeData));
                    jsonText.append("  \"").append(threeData.getJsonKey()).append("\": ").append(s2).append(i < dataList.size() - 1 ? "," : "");
                }
                jsonText.append("}}");
                bw.write("<code><pre id=\"" + entry.getRegistryName().toString() + "_example\"></pre></code>");
                bw.write("<script> var json = JSON.parse('" + jsonText.toString() + "');");
                bw.write("document.getElementById('" + entry.getRegistryName().toString() + "_example').innerHTML = JSON.stringify(json, undefined, 2);</script>");
                bw.write("\n");
                bw.write("<table>\n<tr><th>Setting</th><th>Type</th><th>Default</th><th>Description</th></tr>\n");
                for (ThreeData<?> threeData : dataList) {
                    s2 = threeData.getJsonString(ability.getDataManager().getDefaultValue(threeData));
                    bw.write("<tr>\n<td><code>" + threeData.getJsonKey() + "</code></td>\n<td><code>" + threeData.getType().getTypeName().substring(threeData.getType().getTypeName().lastIndexOf(".") + 1) + "</code></td>\n<td><code>" + s2 + "</code></td>\n<td><p>" + (threeData.getDescription() == null || threeData.getDescription().isEmpty() ? "/" : threeData.getDescription()) + "</p>\n</td></tr><br>");
                }
                bw.write("</table>\n\n\n");
            }
            bw.write("</body></html>");
            bw.close();
            ThreeCore.LOGGER.info("Successfully generated " + file.getName() + "!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ModInfo getModContainerFromId(String modid) {
        for (ModInfo modInfo : ModList.get().getMods()) {
            if (!modInfo.getModId().equals(modid)) continue;
            return modInfo;
        }
        return null;
    }

    public AbilityType(Supplier<Ability> supplier) {
        this.supplier = supplier;
    }

    public AbilityType(Supplier<Ability> supplier, String modid, String name) {
        this.supplier = supplier;
        this.setRegistryName(modid, name);
    }

    public Ability create(String id) {
        Ability a = this.supplier.get();
        a.id = id;
        new RegisterAbilityThreeDataScriptEvent(a).fire();
        return a;
    }

    static {
        DUMMY = new AbilityType(DummyAbility::new, "threecore", "dummy");
        COMMAND = new AbilityType(CommandAbility::new, "threecore", "command");
        HEALING = new AbilityType(HealingAbility::new, "threecore", "healing");
        FLIGHT = new AbilityType(FlightAbility::new, "threecore", "flight");
        ACCELERATING_FLIGHT = new AbilityType(AcceleratingFlightAbility::new, "threecore", "accelerating_flight");
        TELEPORT = new AbilityType(TeleportAbility::new, "threecore", "teleport");
        ATTRIBUTE_MODIFIER = new AbilityType(AttributeModifierAbility::new, "threecore", "attribute_modifier");
        INVISIBILITY = new AbilityType(InvisibilityAbility::new, "threecore", "invisibility");
        SLOWFALL = new AbilityType(SlowfallAbility::new, "threecore", "slowfall");
        WATER_BREATHING = new AbilityType(WaterBreathingAbility::new, "threecore", "water_breathing");
        SIZE_CHANGE = new AbilityType(SizeChangeAbility::new, "threecore", "size_change");
        CUSTOM_HOTBAR = new AbilityType(CustomHotbarAbility::new, "threecore", "custom_hotbar");
        OPENING_NBT_TIMER = new AbilityType(OpeningNbtTimerAbility::new, "threecore", "opening_nbt_timer");
        MODEL_LAYER = new AbilityType(ModelLayerAbility::new, "threecore", "model_layer");
        PROJECTILE = new AbilityType(ProjectileAbility::new, "threecore", "projectile");
        DAMAGE_IMMUNITY = new AbilityType(DamageImmunityAbility::new, "threecore", "damage_immunity");
        POTION_EFFECT = new AbilityType(PotionEffectAbility::new, "threecore", "potion_effect");
        MULTI_JUMP = new AbilityType(MultiJumpAbility::new, "threecore", "multi_jump");
        NAME_CHANGE = new AbilityType(NameChangeAbility::new, "threecore", "name_change");
        HUD = new AbilityType(HUDAbility::new, "threecore", "hud");
        SKIN_CHANGE = new AbilityType(SkinChangeAbility::new, "threecore", "skin_change");
        HIDE_BODY_PARTS = new AbilityType(HideBodyPartsAbility::new, "threecore", "hide_body_parts");
        CHANGE_ABILITY_TAB_TEXTURE = new AbilityType(ChangeAbilityTabTextureAbility::new, "threecore", "change_ability_tab_texture");
        ENERGY = new AbilityType(EnergyAbility::new, "threecore", "energy");
    }
}

