/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import net.minecraft.entity.LivingEntity;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.util.icon.TexturedIcon;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class HealingAbility
extends Ability {
    public static ThreeData<Integer> FREQUENCY = new IntegerThreeData("frequency").setSyncType(EnumSync.NONE).enableSetting("frequency", "Sets the frequency of healing (in ticks)");
    public static ThreeData<Float> AMOUNT = new FloatThreeData("amount").setSyncType(EnumSync.NONE).enableSetting("amount", "Sets the amount of hearts for each healing");

    public HealingAbility() {
        super(AbilityType.HEALING);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(ICON, new TexturedIcon(TexturedIcon.ICONS_TEXTURE, 0, 0, 16, 16));
        this.dataManager.register((ThreeData)FREQUENCY, (Object)20);
        this.dataManager.register((ThreeData)AMOUNT, Float.valueOf(0.5f));
    }

    @Override
    public void action(LivingEntity entity) {
        int frequency = this.dataManager.get(FREQUENCY);
        if (frequency != 0 && this.ticks % frequency == 0) {
            entity.func_70691_i(this.dataManager.get(AMOUNT).floatValue());
        }
    }
}

