/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.threedata.CompoundNBTThreeData;
import net.threetag.threecore.util.threedata.EntityTypeThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class ProjectileAbility
extends Ability {
    public static final ThreeData<EntityType<?>> ENTITY_TYPE = new EntityTypeThreeData("entity_type").setSyncType(EnumSync.NONE).enableSetting("Determines the entity that will be spawned");
    public static final ThreeData<CompoundNBT> ENTITY_DATA = new CompoundNBTThreeData("entity_data").setSyncType(EnumSync.NONE).enableSetting("NBT tag for the entity that will be spawned");
    public static final ThreeData<Float> INACCURACY = new FloatThreeData("inaccuracy").setSyncType(EnumSync.NONE).enableSetting("Determines the inaccuracy when shooting the projectile");
    public static final ThreeData<Float> VELOCITY = new FloatThreeData("velocity").setSyncType(EnumSync.NONE).enableSetting("Determines the velocity when shooting the projectile");

    public ProjectileAbility() {
        super(AbilityType.PROJECTILE);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)ENTITY_TYPE, EntityType.field_200746_al);
        this.dataManager.register((ThreeData)ENTITY_DATA, new CompoundNBT());
        this.dataManager.register((ThreeData)INACCURACY, Float.valueOf(0.0f));
        this.dataManager.register((ThreeData)VELOCITY, Float.valueOf(1.5f));
        this.dataManager.register(ICON, new ItemIcon((IItemProvider)Items.field_151126_ay));
    }

    @Override
    public void action(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            CompoundNBT compound = this.dataManager.get(ENTITY_DATA).func_74737_b();
            compound.func_74778_a("id", this.dataManager.get(ENTITY_TYPE).getRegistryName().toString());
            ServerWorld world = (ServerWorld)entity.field_70170_p;
            EntityType.func_220335_a((CompoundNBT)compound, (World)world, projectile -> {
                if (!(projectile instanceof ProjectileEntity)) {
                    return null;
                }
                projectile.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() - 0.1, entity.func_226281_cx_(), projectile.field_70177_z, projectile.field_70125_A);
                float pitchOffset = 0.0f;
                float velocity = this.dataManager.get(VELOCITY).floatValue();
                float inaccuracy = this.dataManager.get(INACCURACY).floatValue();
                float f = -MathHelper.func_76126_a((float)(entity.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(entity.field_70125_A * ((float)Math.PI / 180)));
                float f1 = -MathHelper.func_76126_a((float)((entity.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
                float f2 = MathHelper.func_76134_b((float)(entity.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(entity.field_70125_A * ((float)Math.PI / 180)));
                ((ProjectileEntity)projectile).func_70186_c((double)f, (double)f1, (double)f2, velocity, inaccuracy);
                Vector3d vec3d = entity.func_213322_ci();
                projectile.func_213317_d(projectile.func_213322_ci().func_72441_c(vec3d.field_72450_a, entity.func_233570_aj_() ? 0.0 : vec3d.field_72448_b, vec3d.field_72449_c));
                if (projectile instanceof ThrowableEntity) {
                    ((ThrowableEntity)projectile).func_212361_a((Entity)entity);
                }
                return !world.func_217470_d(projectile) ? null : projectile;
            });
        }
    }
}

