/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.ability.condition.KeyboundCondition;
import net.threetag.threecore.event.AbilityEnableChangeEvent;
import net.threetag.threecore.scripts.events.AbilityLockedScriptEvent;
import net.threetag.threecore.scripts.events.AbilityUnlockedScriptEvent;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.ThreeData;

public class AbilityConditionManager
implements INBTSerializable<CompoundNBT> {
    public final Ability ability;
    protected boolean unlocked = true;
    protected boolean enabled = false;
    protected HashMap<Condition, Boolean> conditions = new HashMap();

    public AbilityConditionManager(Ability ability) {
        this.ability = ability;
    }

    public void readFromJson(JsonObject jsonObject) {
        if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"conditions")) {
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"conditions");
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonCondition = jsonElement.getAsJsonObject();
                ConditionType conditionType = (ConditionType)ConditionType.REGISTRY.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonCondition, (String)"type")));
                if (conditionType != null) {
                    Condition condition = conditionType.create(this.ability);
                    condition.readFromJson(jsonCondition);
                    this.addCondition(condition);
                    continue;
                }
                throw new JsonParseException("Condition type " + JSONUtils.func_151200_h((JsonObject)jsonCondition, (String)"type") + " does not exist!");
            }
        }
    }

    public Set<Condition> getConditions() {
        return this.conditions.keySet();
    }

    public AbilityConditionManager addCondition(Condition condition) {
        return this.addCondition(condition, false);
    }

    public AbilityConditionManager addCondition(Condition condition, boolean active) {
        if (condition.getUniqueId() == null) {
            UUID uuid = UUID.randomUUID();
            while (this.getByUniqueId(uuid) != null) {
                uuid = UUID.randomUUID();
            }
            condition.id = uuid;
        }
        this.conditions.put(condition, active);
        return this;
    }

    public Condition getByUniqueId(UUID uuid) {
        Objects.requireNonNull(uuid);
        for (Condition c : this.getConditions()) {
            if (!c.getUniqueId().equals(uuid)) continue;
            return c;
        }
        return null;
    }

    public void update(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            boolean u = true;
            boolean e = true;
            for (Condition condition2 : this.conditions.keySet()) {
                boolean b;
                boolean active = this.conditions.get(condition2);
                boolean bl = b = condition2.getDataManager().get(Condition.INVERT).booleanValue() != condition2.test(entity);
                if (b != active) {
                    this.conditions.put(condition2, b);
                    this.ability.sync = this.ability.sync.add(EnumSync.EVERYONE);
                }
                if (condition2.dataManager.get(Condition.ENABLING).booleanValue()) {
                    e = e && b;
                    continue;
                }
                u = u && b;
            }
            if (e != this.enabled) {
                if (e && !MinecraftForge.EVENT_BUS.post((Event)new AbilityEnableChangeEvent(this.ability, entity, AbilityEnableChangeEvent.Type.ENABLED))) {
                    this.enabled = true;
                } else if (!e && !MinecraftForge.EVENT_BUS.post((Event)new AbilityEnableChangeEvent(this.ability, entity, AbilityEnableChangeEvent.Type.DISABLED))) {
                    this.enabled = false;
                }
                this.ability.sync = this.ability.sync.add(EnumSync.EVERYONE);
            }
            if (u != this.unlocked) {
                this.unlocked = u;
                if (this.unlocked) {
                    new AbilityUnlockedScriptEvent(entity, this.ability).fire();
                } else {
                    new AbilityLockedScriptEvent(entity, this.ability).fire();
                }
                this.ability.sync = this.ability.sync.add(EnumSync.EVERYONE);
            }
            if (this.enabled) {
                this.conditions.forEach((condition, aBoolean) -> condition.whileEnabled(entity));
            }
        }
    }

    public void firstTick() {
        this.conditions.forEach((condition, aBoolean) -> condition.firstTick());
    }

    public void lastTick() {
        this.conditions.forEach((condition, aBoolean) -> condition.lastTick());
    }

    public void onKeyPressed() {
        if (this.isUnlocked()) {
            for (Condition condition : this.conditions.keySet()) {
                if (!(condition instanceof KeyboundCondition)) continue;
                ((KeyboundCondition)condition).onKeyPressed();
            }
        }
    }

    public void onKeyReleased() {
        if (this.isUnlocked()) {
            for (Condition condition : this.conditions.keySet()) {
                if (!(condition instanceof KeyboundCondition)) continue;
                ((KeyboundCondition)condition).onKeyReleased();
            }
        }
    }

    public void disableKeybounds() {
        for (Condition condition : this.conditions.keySet()) {
            if (!(condition instanceof KeyboundCondition)) continue;
            condition.dataManager.set((ThreeData)KeyboundCondition.ENABLED, (Object)false);
        }
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public boolean isEnabled() {
        return this.isUnlocked() && this.enabled;
    }

    public boolean needsKey() {
        for (Condition condition : this.conditions.keySet()) {
            if (!condition.dataManager.get(Condition.NEEDS_KEY).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(Condition condition) {
        return this.conditions.get(condition);
    }

    public List<Condition> getFilteredConditions(boolean enabling) {
        return this.conditions.keySet().stream().filter(c -> c.getDataManager().get(Condition.ENABLING) == enabling).collect(Collectors.toList());
    }

    public List<Condition> getFilteredConditions(boolean enabling, boolean active) {
        return this.conditions.keySet().stream().filter(c -> c.getDataManager().get(Condition.ENABLING) == enabling && this.conditions.get(c) == active).collect(Collectors.toList());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("Unlocked", this.unlocked);
        nbt.func_74757_a("Enabled", this.enabled);
        ListNBT list = new ListNBT();
        this.conditions.forEach((abilityCondition, aBoolean) -> {
            CompoundNBT conditionTag = abilityCondition.serializeNBT();
            conditionTag.func_74757_a("Active", aBoolean.booleanValue());
            list.add((Object)conditionTag);
        });
        nbt.func_218657_a("Conditions", (INBT)list);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.unlocked = nbt.func_74767_n("Unlocked");
        this.enabled = nbt.func_74767_n("Enabled");
        this.conditions = new HashMap();
        ListNBT list = nbt.func_150295_c("Conditions", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT conditionTag = list.func_150305_b(i);
            ConditionType conditionType = (ConditionType)ConditionType.REGISTRY.getValue(new ResourceLocation(conditionTag.func_74779_i("ConditionType")));
            if (conditionType != null) {
                Condition condition = conditionType.create(this.ability);
                condition.deserializeNBT(conditionTag);
                this.addCondition(condition, conditionTag.func_74767_n("Active"));
                continue;
            }
            ThreeCore.LOGGER.error("Condition type " + conditionTag.func_74779_i("ConditionType") + " does not exist!");
        }
    }

    public CompoundNBT getUpdatePacket() {
        return this.serializeNBT();
    }

    public void readUpdatePacket(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }
}

