/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.AbilitiesLockedCondition;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.AttributeModifierAbility;
import net.threetag.threecore.ability.condition.AbilityEnabledCondition;
import net.threetag.threecore.ability.condition.AbilityUnlockedCondition;
import net.threetag.threecore.ability.condition.ActionCondition;
import net.threetag.threecore.ability.condition.ComboCondition;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.CooldownCondition;
import net.threetag.threecore.ability.condition.CuriosSlotCondition;
import net.threetag.threecore.ability.condition.EquipmentSlotCondition;
import net.threetag.threecore.ability.condition.ExclusiveCondition;
import net.threetag.threecore.ability.condition.EyesInFluidCondition;
import net.threetag.threecore.ability.condition.HeldCondition;
import net.threetag.threecore.ability.condition.ItemBuyableAbilityCondition;
import net.threetag.threecore.ability.condition.ItemIntegerNbtCondition;
import net.threetag.threecore.ability.condition.KarmaCondition;
import net.threetag.threecore.ability.condition.LivingValuesCondition;
import net.threetag.threecore.ability.condition.PotionCondition;
import net.threetag.threecore.ability.condition.SizeCondition;
import net.threetag.threecore.ability.condition.ThreeDataCondition;
import net.threetag.threecore.ability.condition.ToggleCondition;
import net.threetag.threecore.ability.condition.WearingCuriosCondition;
import net.threetag.threecore.ability.condition.WearingItemCondition;
import net.threetag.threecore.ability.condition.WearingItemTagCondition;
import net.threetag.threecore.ability.condition.XPBuyableAbilityCondition;
import net.threetag.threecore.ability.condition.XPCondition;
import net.threetag.threecore.util.threedata.ThreeData;

@Mod.EventBusSubscriber(modid="threecore", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConditionType
extends ForgeRegistryEntry<ConditionType> {
    public static IForgeRegistry<ConditionType> REGISTRY;
    public static final ConditionType ACTION;
    public static final ConditionType HELD;
    public static final ConditionType TOGGLE;
    public static final ConditionType COOLDOWN;
    public static final ConditionType ABILITY_ENABLED;
    public static final ConditionType ABILITY_UNLOCKED;
    public static final ConditionType KARMA;
    public static final ConditionType XP_BUY;
    public static final ConditionType ITEM_BUY;
    public static final ConditionType EQUIPMENT_SLOT;
    public static final ConditionType XP;
    public static final ConditionType WEARING_ITEM;
    public static final ConditionType WEARING_ITEM_TAG;
    public static final ConditionType ITEM_INTEGER_NBT;
    public static final ConditionType EYES_IN_FLUID;
    public static final ConditionType SIZE;
    public static final ConditionType ABILITIES_LOCKED;
    public static final ConditionType LIVING_VALUES;
    public static final ConditionType POTION;
    public static final ConditionType THREE_DATA;
    public static final ConditionType EXCLUSIVE;
    public static final ConditionType COMBO;
    public static final ConditionType CURIOS_SLOT;
    public static final ConditionType WEARING_CURIOS;
    private Function<Ability, Condition> function;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("threecore", "condition_types")).setType(ConditionType.class).setIDRange(0, 2048).create();
    }

    @SubscribeEvent
    public static void onRegisterConditionTypes(RegistryEvent.Register<ConditionType> e) {
        e.getRegistry().register((IForgeRegistryEntry)ACTION);
        e.getRegistry().register((IForgeRegistryEntry)HELD);
        e.getRegistry().register((IForgeRegistryEntry)TOGGLE);
        e.getRegistry().register((IForgeRegistryEntry)COOLDOWN);
        e.getRegistry().register((IForgeRegistryEntry)ABILITY_ENABLED);
        e.getRegistry().register((IForgeRegistryEntry)ABILITY_UNLOCKED);
        e.getRegistry().register((IForgeRegistryEntry)KARMA);
        e.getRegistry().register((IForgeRegistryEntry)XP_BUY);
        e.getRegistry().register((IForgeRegistryEntry)ITEM_BUY);
        e.getRegistry().register((IForgeRegistryEntry)EQUIPMENT_SLOT);
        e.getRegistry().register((IForgeRegistryEntry)XP);
        e.getRegistry().register((IForgeRegistryEntry)WEARING_ITEM);
        e.getRegistry().register((IForgeRegistryEntry)WEARING_ITEM_TAG);
        e.getRegistry().register((IForgeRegistryEntry)ITEM_INTEGER_NBT);
        e.getRegistry().register((IForgeRegistryEntry)EYES_IN_FLUID);
        e.getRegistry().register((IForgeRegistryEntry)SIZE);
        e.getRegistry().register((IForgeRegistryEntry)ABILITIES_LOCKED);
        e.getRegistry().register((IForgeRegistryEntry)LIVING_VALUES);
        e.getRegistry().register((IForgeRegistryEntry)POTION);
        e.getRegistry().register((IForgeRegistryEntry)THREE_DATA);
        e.getRegistry().register((IForgeRegistryEntry)EXCLUSIVE);
        e.getRegistry().register((IForgeRegistryEntry)COMBO);
        e.getRegistry().register((IForgeRegistryEntry)CURIOS_SLOT);
        e.getRegistry().register((IForgeRegistryEntry)WEARING_CURIOS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateHtmlFile(File file) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("<html><head><title>Conditions</title><style>\ntable{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}\n</style><link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"https://i.imgur.com/am80ox1.png\"></head><body>");
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            HashMap<String, List> sorted = new HashMap<String, List>();
            AttributeModifierAbility ability_ = new AttributeModifierAbility();
            for (ConditionType types : REGISTRY.getValues()) {
                Condition condition = types.create(ability_);
                conditions.add(condition);
                String modName = AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()) != null ? AbilityType.getModContainerFromId(types.getRegistryName().func_110624_b()).getDisplayName() : types.getRegistryName().func_110624_b();
                List<Condition> modsConditions = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
                modsConditions.add(condition);
                sorted.put(modName, modsConditions);
            }
            sorted.forEach((s, l) -> {
                try {
                    bw.write("<h1>" + s + "</h1>\n");
                    bw.write("<ul>\n");
                    for (Condition condition : l) {
                        bw.write("<li><a href=\"#" + condition.type.getRegistryName().toString() + "\">" + StringUtils.func_76338_a((String)condition.getDisplayName().getString()) + "</a></li>\n");
                    }
                    bw.write("</ul>\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            bw.write("\n");
            for (Condition condition : conditions) {
                String s2;
                ConditionType entry = condition.type;
                bw.write("<hr>\n");
                bw.write("<p><h1 id=\"" + entry.getRegistryName().toString() + "\">" + StringUtils.func_76338_a((String)condition.getDisplayName().getString()) + "</h1>\n");
                bw.write("<h3>" + entry.getRegistryName().toString() + "</h3>\n");
                List<ThreeData<?>> dataList = condition.dataManager.getSettingData();
                bw.write("<p>Example:<br>\n");
                StringBuilder jsonText = new StringBuilder("[{\"type\":\"").append(entry.getRegistryName().toString()).append("\",");
                for (int i = 0; i < dataList.size(); ++i) {
                    ThreeData<?> threeData = dataList.get(i);
                    s2 = threeData.getJsonString(condition.getDataManager().getDefaultValue(threeData));
                    jsonText.append("  \"").append(threeData.getJsonKey()).append("\": ").append(s2).append(i < dataList.size() - 1 ? "," : "");
                }
                jsonText.append("}]");
                bw.write("<code><pre id=\"" + entry.getRegistryName().toString() + "_example\"></pre></code>");
                bw.write("<script> var json = JSON.parse('" + jsonText.toString() + "');");
                bw.write("document.getElementById('" + entry.getRegistryName().toString() + "_example').innerHTML = JSON.stringify(json, undefined, 2);</script>");
                bw.write("\n");
                bw.write("<table>\n<tr><th>Setting</th><th>Type</th><th>Default</th><th>Description</th></tr>\n");
                for (ThreeData<?> threeData : dataList) {
                    s2 = threeData.getJsonString(condition.getDataManager().getDefaultValue(threeData));
                    bw.write("<tr>\n<td><code>" + threeData.getJsonKey() + "</code></td>\n<td><code>" + threeData.getType().getTypeName().substring(threeData.getType().getTypeName().lastIndexOf(".") + 1) + "</code></td>\n<td><code>" + s2 + "</code></td>\n<td><p>" + (threeData.getDescription() == null || threeData.getDescription().isEmpty() ? "/" : threeData.getDescription()) + "</p>\n</td></tr><br>");
                }
                bw.write("</table>\n\n\n");
            }
            bw.write("</body></html>");
            bw.close();
            ThreeCore.LOGGER.info("Successfully generated " + file.getName() + "!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConditionType(Function<Ability, Condition> function) {
        this.function = function;
    }

    public ConditionType(Function<Ability, Condition> function, String modid, String name) {
        this.function = function;
        this.setRegistryName(modid, name);
    }

    public Condition create(Ability ability) {
        return this.function.apply(ability);
    }

    static {
        ACTION = new ConditionType(ActionCondition::new, "threecore", "action");
        HELD = new ConditionType(HeldCondition::new, "threecore", "held");
        TOGGLE = new ConditionType(ToggleCondition::new, "threecore", "toggle");
        COOLDOWN = new ConditionType(CooldownCondition::new, "threecore", "cooldown");
        ABILITY_ENABLED = new ConditionType(AbilityEnabledCondition::new, "threecore", "ability_enabled");
        ABILITY_UNLOCKED = new ConditionType(AbilityUnlockedCondition::new, "threecore", "ability_unlocked");
        KARMA = new ConditionType(KarmaCondition::new, "threecore", "karma");
        XP_BUY = new ConditionType(XPBuyableAbilityCondition::new, "threecore", "xp_buy");
        ITEM_BUY = new ConditionType(ItemBuyableAbilityCondition::new, "threecore", "item_buy");
        EQUIPMENT_SLOT = new ConditionType(EquipmentSlotCondition::new, "threecore", "equipment_slot");
        XP = new ConditionType(XPCondition::new, "threecore", "xp");
        WEARING_ITEM = new ConditionType(WearingItemCondition::new, "threecore", "wearing_item");
        WEARING_ITEM_TAG = new ConditionType(WearingItemTagCondition::new, "threecore", "wearing_item_tag");
        ITEM_INTEGER_NBT = new ConditionType(ItemIntegerNbtCondition::new, "threecore", "item_integer_nbt");
        EYES_IN_FLUID = new ConditionType(EyesInFluidCondition::new, "threecore", "eyes_in_fluid");
        SIZE = new ConditionType(SizeCondition::new, "threecore", "size");
        ABILITIES_LOCKED = new ConditionType(AbilitiesLockedCondition::new, "threecore", "abilities_locked");
        LIVING_VALUES = new ConditionType(LivingValuesCondition::new, "threecore", "living_values");
        POTION = new ConditionType(PotionCondition::new, "threecore", "has_potions");
        THREE_DATA = new ConditionType(ThreeDataCondition::new, "threecore", "three_data");
        EXCLUSIVE = new ConditionType(ExclusiveCondition::new, "threecore", "exclusive");
        COMBO = new ConditionType(ComboCondition::new, "threecore", "combo");
        CURIOS_SLOT = new ConditionType(CuriosSlotCondition::new, "threecore", "curios_slot");
        WEARING_CURIOS = new ConditionType(WearingCuriosCondition::new, "threecore", "wearing_curios");
    }
}

