/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.StringThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class ThreeDataCondition
extends Condition {
    public static final ThreeData<String> TEST_ABILITY = new StringThreeData("test_ability").setSyncType(EnumSync.SELF).enableSetting("test_ability", "The ability to test the threedata from");
    public static final ThreeData<String> DATA_NAME = new StringThreeData("data_name").setSyncType(EnumSync.SELF).enableSetting("data_name", "The name of the data to test");
    public static final ThreeData<Float> ADD_AMOUNT = new FloatThreeData("add_amount").setSyncType(EnumSync.SELF).enableSetting("add_amount", "The amount of data to add after checking");
    public static final ThreeData<String> TEST_VALUE = new StringThreeData("test_value").setSyncType(EnumSync.SELF).enableSetting("test_value", "The value to test the threedata's value against, as a string. Supports string, boolean, float and integer");
    public static final ThreeData<String> TEST_TYPE = new StringThreeData("test_type").setSyncType(EnumSync.SELF).enableSetting("test_type", "The type of test for the value, GREATER, LESS, or EQUAL");
    public static final ThreeData<Float> AMOUNT_MIN = new FloatThreeData("add_amount").setSyncType(EnumSync.SELF).enableSetting("amount_min", "The minimum amount the data can be after adding add_amount");
    public static final ThreeData<Float> AMOUNT_MAX = new FloatThreeData("add_amount").setSyncType(EnumSync.SELF).enableSetting("amount_max", "The maximum amount the data can be after adding add_amount");

    public ThreeDataCondition(Ability ability) {
        super(ConditionType.THREE_DATA, ability);
    }

    @Override
    public boolean test(LivingEntity entity) {
        try {
            TestType testType = TestType.valueOf(this.getDataManager().get(TEST_TYPE).toUpperCase());
            for (Ability a : AbilityHelper.getAbilities(entity)) {
                ThreeData<?> t;
                if (!a.getId().equals(this.dataManager.get(TEST_ABILITY)) || (t = a.getDataManager().getDataByName(this.dataManager.get(DATA_NAME))) == null) continue;
                if (t instanceof BooleanThreeData || t instanceof StringThreeData) {
                    if (testType != TestType.EQUAL || !a.getDataManager().get(t).toString().equals(this.dataManager.get(TEST_VALUE))) continue;
                    return true;
                }
                if (t instanceof FloatThreeData) {
                    float testValue = Float.parseFloat(this.dataManager.get(TEST_VALUE));
                    float realValue = a.getDataManager().get((FloatThreeData)t).floatValue();
                    switch (testType) {
                        case GREATER: {
                            return realValue > testValue;
                        }
                        case LESS: {
                            return realValue < testValue;
                        }
                        case EQUAL: {
                            return realValue == testValue;
                        }
                    }
                    continue;
                }
                if (!(t instanceof IntegerThreeData)) continue;
                int testValue = Integer.parseInt(this.dataManager.get(TEST_VALUE));
                int realValue = a.getDataManager().get((IntegerThreeData)t);
                switch (testType) {
                    case GREATER: {
                        return realValue > testValue;
                    }
                    case LESS: {
                        return realValue < testValue;
                    }
                    case EQUAL: {
                        return realValue == testValue;
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void whileEnabled(LivingEntity entity) {
        for (Ability a : AbilityHelper.getAbilities(entity)) {
            if (!a.getId().equals(this.dataManager.get(TEST_ABILITY))) continue;
            ThreeData<?> t = a.getDataManager().getDataByName(this.dataManager.get(DATA_NAME));
            if (t instanceof FloatThreeData) {
                float addAmount = this.dataManager.get(ADD_AMOUNT).floatValue();
                float newAmount = MathHelper.func_76131_a((float)(a.getDataManager().get((FloatThreeData)t).floatValue() + addAmount), (float)this.dataManager.get(AMOUNT_MIN).floatValue(), (float)this.dataManager.get(AMOUNT_MAX).floatValue());
                a.getDataManager().set((ThreeData)((FloatThreeData)t), Float.valueOf(newAmount));
                continue;
            }
            if (!(t instanceof IntegerThreeData)) continue;
            int addAmount = this.dataManager.get(ADD_AMOUNT).intValue();
            int newAmount = MathHelper.func_76125_a((int)(a.getDataManager().get((IntegerThreeData)t) + addAmount), (int)this.dataManager.get(AMOUNT_MIN).intValue(), (int)this.dataManager.get(AMOUNT_MAX).intValue());
            a.getDataManager().set((ThreeData)((IntegerThreeData)t), (Object)newAmount);
        }
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)TEST_ABILITY, "");
        this.dataManager.register((ThreeData)DATA_NAME, "");
        this.dataManager.register((ThreeData)ADD_AMOUNT, Float.valueOf(0.0f));
        this.dataManager.register((ThreeData)TEST_VALUE, "");
        this.dataManager.register((ThreeData)TEST_TYPE, "GREATER");
        this.dataManager.register((ThreeData)AMOUNT_MAX, Float.valueOf(Float.MAX_VALUE));
        this.dataManager.register((ThreeData)AMOUNT_MIN, Float.valueOf(0.0f));
    }

    static enum TestType {
        GREATER,
        LESS,
        EQUAL;

    }
}

