/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.BuyableAbilityCondition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.ability.BuyAbilityScreen;
import net.threetag.threecore.util.icon.ExperienceIcon;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.ExperienceThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class XPBuyableAbilityCondition
extends BuyableAbilityCondition {
    public static ThreeData<ExperienceThreeData.Experience> EXPERIENCE = new ExperienceThreeData("experience").setSyncType(EnumSync.SELF).enableSetting("experience", "Determines the amount of XP the player has to spend to activate this condition.");

    public XPBuyableAbilityCondition(Ability ability) {
        super(ConditionType.XP_BUY, ability);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register((ThreeData)EXPERIENCE, new ExperienceThreeData.Experience(false, 5));
    }

    @Override
    public ITextComponent createTitle() {
        ExperienceThreeData.Experience xp = this.dataManager.get(EXPERIENCE);
        if (xp == null) {
            return super.createTitle();
        }
        if (xp.isLevels()) {
            return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ".levels" + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{xp.getValue()});
        }
        return new TranslationTextComponent(Util.func_200697_a((String)"ability.condition", (ResourceLocation)this.type.getRegistryName()) + ".points" + ((Boolean)this.dataManager.get(INVERT) != false ? ".not" : ""), new Object[]{xp.getValue()});
    }

    @Override
    public boolean isAvailable(LivingEntity entity) {
        return entity instanceof PlayerEntity && this.dataManager.get(EXPERIENCE).has((PlayerEntity)entity);
    }

    @Override
    public boolean takeFromEntity(LivingEntity entity) {
        boolean available = this.isAvailable(entity);
        if (entity instanceof PlayerEntity) {
            this.dataManager.get(EXPERIENCE).take((PlayerEntity)entity);
        }
        return available;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen getScreen(AbilitiesScreen screen) {
        return (Boolean)this.dataManager.get(BOUGHT) != false ? null : new BuyAbilityScreen(this.ability, this, new ExperienceIcon(this.dataManager.get(EXPERIENCE)), (ITextComponent)new TranslationTextComponent("ability.condition.threecore.xp_buy.info." + (this.dataManager.get(EXPERIENCE).isLevels() ? "levels" : "points"), new Object[]{this.dataManager.get(EXPERIENCE).getValue()}), screen);
    }
}

