/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.addonpacks.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.item.Food;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.addonpacks.AddonPackManager;
import net.threetag.threecore.addonpacks.item.ArmorMaterialParser;
import net.threetag.threecore.addonpacks.item.ItemGroupParser;
import net.threetag.threecore.addonpacks.item.ItemTierParser;
import net.threetag.threecore.addonpacks.item.LoadingOrderParser;
import net.threetag.threecore.addonpacks.item.SuitSetItemParser;
import net.threetag.threecore.item.AbilityArmorItem;
import net.threetag.threecore.item.AbilityItem;
import net.threetag.threecore.item.AxeAbilityItem;
import net.threetag.threecore.item.HoeAbilityItem;
import net.threetag.threecore.item.ItemGroupRegistry;
import net.threetag.threecore.item.ItemTierRegistry;
import net.threetag.threecore.item.PickaxeAbilityItem;
import net.threetag.threecore.item.ShieldAbilityItem;
import net.threetag.threecore.item.ShovelAbilityItem;
import net.threetag.threecore.item.SimpleArmorMaterial;
import net.threetag.threecore.item.SimpleItemTier;
import net.threetag.threecore.item.SwordAbilityItem;

public class ItemParser {
    public static final int resourcePrefix = "items/".length();
    public static final int resourceSuffix = ".json".length();
    private static Map<ResourceLocation, BiFunction<JsonObject, Item.Properties, Item>> itemFunctions = Maps.newHashMap();
    private static List<Pair<EventPriority, ISpecialItemParser>> specialItemParsers = Lists.newArrayList();
    public static final Map<String, List<String>> LOADING_ORDER = Maps.newHashMap();

    public static void registerItemParser(ResourceLocation resourceLocation, BiFunction<JsonObject, Item.Properties, Item> function) {
        Preconditions.checkNotNull((Object)resourceLocation);
        Preconditions.checkNotNull(function);
        itemFunctions.put(resourceLocation, function);
    }

    public static void registerSpecialItemParser(ISpecialItemParser parser) {
        ItemParser.registerSpecialItemParser(parser, EventPriority.NORMAL);
    }

    public static void registerSpecialItemParser(ISpecialItemParser parser, EventPriority priority) {
        Preconditions.checkNotNull((Object)parser);
        Preconditions.checkNotNull((Object)priority);
        specialItemParsers.add((Pair<EventPriority, ISpecialItemParser>)Pair.of((Object)priority, (Object)parser));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerItems(RegistryEvent.Register<Item> e) {
        IResourceManager resourceManager = AddonPackManager.getInstance().getResourceManager();
        specialItemParsers.sort(Comparator.comparingInt(o -> ((EventPriority)o.getFirst()).ordinal()));
        ArrayList used = Lists.newArrayList();
        for (Object resourcelocation : resourceManager.func_199003_a("items", name -> name.endsWith(".json"))) {
            for (Pair<EventPriority, ISpecialItemParser> pair : specialItemParsers) {
                if (!((ISpecialItemParser)pair.getSecond()).applies((ResourceLocation)resourcelocation)) continue;
                ((ISpecialItemParser)pair.getSecond()).process(resourceManager, (ResourceLocation)resourcelocation, (IForgeRegistry<Item>)e.getRegistry());
                used.add(resourcelocation);
            }
        }
        LinkedHashMap items = Maps.newLinkedHashMap();
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a("items", name -> name.endsWith(".json") && !name.startsWith("_"))) {
            String string = resourcelocation.func_110623_a();
            ResourceLocation id = new ResourceLocation(resourcelocation.func_110624_b(), string.substring(resourcePrefix, string.length() - resourceSuffix));
            if (used.contains(resourcelocation)) continue;
            try {
                IResource iresource = resourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    items.put(id, JSONUtils.func_193839_a((Gson)AddonPackManager.GSON, (Reader)new BufferedReader(new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8)), JsonObject.class));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (Throwable throwable) {
                ThreeCore.LOGGER.error("Couldn't read addonpack item {} from {}", (Object)id, (Object)resourcelocation, (Object)throwable);
            }
        }
        TreeMap sorted = new TreeMap((id1, id2) -> {
            if (id1.func_110624_b().equals(id2.func_110624_b())) {
                List<String> order = LOADING_ORDER.get(id1.func_110624_b());
                if (order == null) {
                    return id1.compareTo(id2);
                }
                if (order.contains(id1.func_110623_a()) && !order.contains(id2.func_110623_a())) {
                    return -1;
                }
                if (!order.contains(id1.func_110623_a()) && order.contains(id2.func_110623_a())) {
                    return 1;
                }
                if (!order.contains(id1.func_110623_a()) && !order.contains(id2.func_110623_a())) {
                    return id1.compareTo(id2);
                }
                return order.indexOf(id1.func_110623_a()) - order.indexOf(id2.func_110623_a());
            }
            return id1.compareTo(id2);
        });
        sorted.putAll(items);
        for (Map.Entry entry : sorted.entrySet()) {
            try {
                Item item = ItemParser.parse((JsonObject)entry.getValue());
                if (item == null) continue;
                item.setRegistryName((ResourceLocation)entry.getKey());
                e.getRegistry().register((IForgeRegistryEntry)item);
                ThreeCore.LOGGER.info("Registered addonpack item {}!", entry.getKey());
            }
            catch (Throwable throwable) {
                ThreeCore.LOGGER.error("Couldn't read addonpack item {}", entry.getKey(), (Object)throwable);
            }
        }
        LOADING_ORDER.clear();
    }

    public static Item parse(JsonObject json) throws JsonParseException {
        BiFunction<JsonObject, Item.Properties, Item> function = itemFunctions.get(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"type")));
        if (function == null) {
            throw new JsonParseException("The item type '" + JSONUtils.func_151200_h((JsonObject)json, (String)"type") + "' does not exist!");
        }
        Item item = function.apply(json, JSONUtils.func_151204_g((JsonObject)json, (String)"properties") ? ItemParser.parseProperties(JSONUtils.func_152754_s((JsonObject)json, (String)"properties")) : new Item.Properties());
        return Objects.requireNonNull(item);
    }

    public static Item.Properties parseProperties(JsonObject json) {
        Item.Properties properties = new Item.Properties();
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"max_stack_size")) {
            properties.func_200917_a(JSONUtils.func_151208_a((JsonObject)json, (String)"max_stack_size", (int)64));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"max_damage")) {
            properties.func_200918_c(JSONUtils.func_151203_m((JsonObject)json, (String)"max_damage"));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"container_item")) {
            properties.func_200919_a((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"container_item"))));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"group")) {
            properties.func_200916_a(ItemGroupRegistry.getItemGroup(JSONUtils.func_151200_h((JsonObject)json, (String)"group")));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"rarity")) {
            properties.func_208103_a(Rarity.valueOf((String)JSONUtils.func_151200_h((JsonObject)json, (String)"rarity").toUpperCase()));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"tool_types")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"tool_types");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject jsonObject = array.get(i).getAsJsonObject();
                properties.addToolType(ItemParser.getToolType(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tool")), JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"level"));
            }
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"food")) {
            JsonObject foodJson = JSONUtils.func_152754_s((JsonObject)json, (String)"food");
            Food.Builder food = new Food.Builder();
            if (JSONUtils.func_151204_g((JsonObject)foodJson, (String)"value")) {
                food.func_221456_a(JSONUtils.func_151203_m((JsonObject)foodJson, (String)"value"));
            }
            if (JSONUtils.func_151204_g((JsonObject)foodJson, (String)"saturation")) {
                food.func_221454_a(JSONUtils.func_151217_k((JsonObject)foodJson, (String)"saturation"));
            }
            if (JSONUtils.func_151204_g((JsonObject)foodJson, (String)"meat") && JSONUtils.func_151212_i((JsonObject)foodJson, (String)"meat")) {
                food.func_221451_a();
            }
            if (JSONUtils.func_151204_g((JsonObject)foodJson, (String)"always_edible") && JSONUtils.func_151212_i((JsonObject)foodJson, (String)"always_edible")) {
                food.func_221455_b();
            }
            if (JSONUtils.func_151204_g((JsonObject)foodJson, (String)"fast_to_eat") && JSONUtils.func_151212_i((JsonObject)foodJson, (String)"fast_to_eat")) {
                food.func_221457_c();
            }
            if (JSONUtils.func_151204_g((JsonObject)foodJson, (String)"effects")) {
                JsonArray effectArray = JSONUtils.func_151214_t((JsonObject)foodJson, (String)"effects");
                for (int i = 0; i < effectArray.size(); ++i) {
                    JsonObject effect = effectArray.get(i).getAsJsonObject();
                    food.func_221452_a(new EffectInstance((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)effect, (String)"effect"))), JSONUtils.func_151208_a((JsonObject)effect, (String)"duration", (int)0), JSONUtils.func_151208_a((JsonObject)effect, (String)"amplifier", (int)0), JSONUtils.func_151209_a((JsonObject)effect, (String)"ambient", (boolean)false), JSONUtils.func_151209_a((JsonObject)effect, (String)"particles", (boolean)true), JSONUtils.func_151209_a((JsonObject)effect, (String)"show_icon", (boolean)true)), JSONUtils.func_151217_k((JsonObject)effect, (String)"probability"));
                }
            }
            properties.func_221540_a(food.func_221453_d());
        }
        return properties;
    }

    public static List<ITextComponent> parseDescriptionLines(JsonElement jsonElement) {
        ArrayList lines = Lists.newArrayList();
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                lines.addAll(ItemParser.parseDescriptionLines(jsonArray.get(i)));
            }
        } else if (jsonElement.isJsonObject()) {
            lines.add(ITextComponent.Serializer.func_240641_a_((JsonElement)jsonElement));
        } else if (jsonElement.isJsonPrimitive()) {
            lines.add(new StringTextComponent(jsonElement.getAsString()));
        }
        return lines;
    }

    public static ToolType getToolType(String name) {
        Map values = (Map)ObfuscationReflectionHelper.getPrivateValue(ToolType.class, null, (String)"values");
        return (ToolType)values.get(name);
    }

    public static IArmorMaterial parseArmorMaterial(JsonObject json) {
        return ItemParser.parseArmorMaterial(json, true);
    }

    public static IArmorMaterial parseArmorMaterial(JsonObject json, boolean requireName) {
        String name = requireName ? JSONUtils.func_151200_h((JsonObject)json, (String)"name") : "";
        int maxDamageFactor = JSONUtils.func_151203_m((JsonObject)json, (String)"max_damage_factor");
        int[] damageReductionAmountArray = new int[4];
        JsonArray dmgReduction = JSONUtils.func_151214_t((JsonObject)json, (String)"damage_reduction");
        if (dmgReduction.size() != 4) {
            throw new JsonParseException("The damage_reduction array must contain 4 entries, one for each armor part!");
        }
        for (int i = 0; i < dmgReduction.size(); ++i) {
            damageReductionAmountArray[i] = dmgReduction.get(i).getAsInt();
        }
        int enchantibility = JSONUtils.func_151208_a((JsonObject)json, (String)"enchantibility", (int)0);
        LazyValue soundEvent = new LazyValue(() -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"equip_sound", (String)""))));
        float toughness = JSONUtils.func_151221_a((JsonObject)json, (String)"toughness", (float)0.0f);
        float knockbackResistance = JSONUtils.func_151221_a((JsonObject)json, (String)"knockback_resistance", (float)0.0f);
        Supplier<Ingredient> repairMaterial = () -> JSONUtils.func_151204_g((JsonObject)json, (String)"repair_material") ? Ingredient.func_199802_a((JsonElement)json.get("repair_material")) : Ingredient.field_193370_a;
        return new SimpleArmorMaterial(name, maxDamageFactor, damageReductionAmountArray, enchantibility, (LazyValue<SoundEvent>)soundEvent, toughness, knockbackResistance, repairMaterial);
    }

    public static IItemTier parseItemTier(JsonObject jsonObject) {
        int maxUses = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"max_uses");
        float efficiency = JSONUtils.func_151217_k((JsonObject)jsonObject, (String)"efficiency");
        float attackDamage = JSONUtils.func_151217_k((JsonObject)jsonObject, (String)"attack_damage");
        int harvestLevel = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"harvest_level");
        int enchantibility = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"enchantibility");
        Supplier<Ingredient> repairMaterial = () -> JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"repair_material") ? Ingredient.func_199802_a((JsonElement)jsonObject.get("repair_material")) : Ingredient.field_193370_a;
        return new SimpleItemTier(maxUses, efficiency, attackDamage, harvestLevel, enchantibility, repairMaterial);
    }

    static {
        ItemParser.registerSpecialItemParser(new ItemGroupParser(), EventPriority.HIGH);
        ItemParser.registerSpecialItemParser(new ArmorMaterialParser(), EventPriority.HIGH);
        ItemParser.registerSpecialItemParser(new ItemTierParser(), EventPriority.HIGH);
        ItemParser.registerSpecialItemParser(new SuitSetItemParser(), EventPriority.LOWEST);
        ItemParser.registerSpecialItemParser(new LoadingOrderParser(), EventPriority.LOWEST);
        ItemParser.registerItemParser(new ResourceLocation("threecore", "default"), AbilityItem::new);
        ItemParser.registerItemParser(new ResourceLocation("threecore", "armor"), AbilityArmorItem::parse);
        ItemParser.registerItemParser(new ResourceLocation("threecore", "shield"), ShieldAbilityItem::parse);
        ItemParser.registerItemParser(new ResourceLocation("threecore", "tool"), (j, p) -> {
            List<ITextComponent> description;
            IItemTier tier;
            JsonElement tierJson = j.get("item_tier");
            IItemTier iItemTier = tier = tierJson.isJsonPrimitive() ? ItemTierRegistry.getItemTier(tierJson.getAsString()) : ItemParser.parseItemTier(tierJson.getAsJsonObject());
            if (tier == null) {
                throw new JsonParseException("The item tier '" + tierJson.getAsString() + "' can not be found!");
            }
            String type = JSONUtils.func_151200_h((JsonObject)j, (String)"tool_type");
            int attackDamage = type.equalsIgnoreCase("hoe") ? 0 : JSONUtils.func_151203_m((JsonObject)j, (String)"attack_damage");
            float attackSpeed = JSONUtils.func_151217_k((JsonObject)j, (String)"attack_speed");
            List<Supplier<Ability>> abilityGenerators = JSONUtils.func_151204_g((JsonObject)j, (String)"abilities") ? AbilityHelper.parseAbilityGenerators(JSONUtils.func_152754_s((JsonObject)j, (String)"abilities"), true) : null;
            List<ITextComponent> list = description = JSONUtils.func_151204_g((JsonObject)j, (String)"description") ? ItemParser.parseDescriptionLines(j.get("description")) : null;
            if (type.equalsIgnoreCase("hoe")) {
                return new HoeAbilityItem(tier, attackSpeed, (Item.Properties)p).setDescription(description).setAbilities(abilityGenerators);
            }
            if (type.equalsIgnoreCase("shovel")) {
                return new ShovelAbilityItem(tier, attackDamage, attackSpeed, (Item.Properties)p).setDescription(description).setAbilities(abilityGenerators);
            }
            if (type.equalsIgnoreCase("axe")) {
                return new AxeAbilityItem(tier, attackDamage, attackSpeed, (Item.Properties)p).setDescription(description).setAbilities(abilityGenerators);
            }
            if (type.equalsIgnoreCase("pickaxe")) {
                return new PickaxeAbilityItem(tier, attackDamage, attackSpeed, (Item.Properties)p).setDescription(description).setAbilities(abilityGenerators);
            }
            if (type.equalsIgnoreCase("sword")) {
                return new SwordAbilityItem(tier, attackDamage, attackSpeed, (Item.Properties)p).setDescription(description).setAbilities(abilityGenerators);
            }
            throw new JsonParseException("Tool type '" + type + "' does not exist!");
        });
    }

    public static interface ISpecialItemParser {
        public boolean applies(ResourceLocation var1);

        public void process(IResourceManager var1, ResourceLocation var2, IForgeRegistry<Item> var3);
    }
}

