/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.addonpacks.item;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.addonpacks.AddonPackManager;
import net.threetag.threecore.addonpacks.item.ItemParser;

public class LoadingOrderParser
implements ItemParser.ISpecialItemParser {
    @Override
    public boolean applies(ResourceLocation resourceLocation) {
        return resourceLocation.func_110623_a().startsWith("items/_loading_order");
    }

    @Override
    public void process(IResourceManager resourceManager, ResourceLocation resourceLocation, IForgeRegistry<Item> registry) {
        try (IResource iresource = resourceManager.func_199002_a(resourceLocation);){
            JsonArray jsonArray = (JsonArray)JSONUtils.func_193839_a((Gson)AddonPackManager.GSON, (Reader)new BufferedReader(new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8)), JsonArray.class);
            List<String> list = ItemParser.LOADING_ORDER.getOrDefault(resourceLocation.func_110624_b(), Lists.newLinkedList());
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(jsonArray.get(i).getAsString());
            }
            ItemParser.LOADING_ORDER.put(resourceLocation.func_110624_b(), list);
        }
        catch (Throwable throwable) {
            ThreeCore.LOGGER.error("Couldn't read custom item loading order from {}", (Object)resourceLocation, (Object)throwable);
        }
    }
}

