/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.addonpacks.item;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.addonpacks.AddonPackManager;
import net.threetag.threecore.addonpacks.item.ItemParser;
import net.threetag.threecore.util.TCJsonUtil;

public class SuitSetItemParser
implements ItemParser.ISpecialItemParser {
    public static final int resourcePrefix = "items/_suit_sets/".length();
    public static final int resourceSuffix = ".json".length();

    @Override
    public boolean applies(ResourceLocation resourceLocation) {
        return resourceLocation.func_110623_a().startsWith("items/_suit_sets/");
    }

    @Override
    public void process(IResourceManager resourceManager, ResourceLocation resourceLocation, IForgeRegistry<Item> registry) {
        String s = resourceLocation.func_110623_a();
        String baseId = s.substring(resourcePrefix, s.length() - resourceSuffix);
        try (IResource iresource = resourceManager.func_199002_a(resourceLocation);){
            JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)AddonPackManager.GSON, (Reader)new BufferedReader(new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8)), JsonObject.class);
            JsonObject armorParts = JSONUtils.func_152754_s((JsonObject)json, (String)"armor_parts");
            JsonObject overrides = JSONUtils.func_151218_a((JsonObject)json, (String)"overrides", (JsonObject)new JsonObject());
            HashMap armorJsons = Maps.newHashMap();
            overrides.addProperty("type", "threecore:armor");
            for (EquipmentSlotType slot2 : EquipmentSlotType.values()) {
                if (slot2.func_188453_a() != EquipmentSlotType.Group.ARMOR || !JSONUtils.func_151204_g((JsonObject)armorParts, (String)slot2.func_188450_d().toLowerCase())) continue;
                armorJsons.put(slot2, JSONUtils.func_152754_s((JsonObject)armorParts, (String)slot2.func_188450_d().toLowerCase()));
            }
            EquipmentSlotType abilitySlot = JSONUtils.func_151204_g((JsonObject)json, (String)"ability_slot") ? EquipmentSlotType.func_188451_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"ability_slot")) : (armorJsons.containsKey(EquipmentSlotType.CHEST) ? EquipmentSlotType.CHEST : (armorJsons.containsKey(EquipmentSlotType.HEAD) ? EquipmentSlotType.HEAD : (armorJsons.containsKey(EquipmentSlotType.LEGS) ? EquipmentSlotType.LEGS : EquipmentSlotType.FEET)));
            for (Map.Entry entry : armorJsons.entrySet()) {
                JsonObject part = TCJsonUtil.merge(JSONUtils.func_212745_a((String)overrides.toString()), (JsonObject)entry.getValue());
                if (entry.getKey() == abilitySlot) {
                    JsonObject abilities = this.convertAbilitiesSection(JSONUtils.func_151218_a((JsonObject)json, (String)"abilities", (JsonObject)new JsonObject()), JSONUtils.func_151204_g((JsonObject)json, (String)"suit_item_tag") ? new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"suit_item_tag")) : null, abilitySlot, Maps.asMap(armorJsons.keySet(), slot -> new ResourceLocation(resourceLocation.func_110624_b(), baseId + "_" + this.toArmorName((EquipmentSlotType)slot))));
                    JsonObject itemAbilities = JSONUtils.func_151218_a((JsonObject)part, (String)"abilities", (JsonObject)new JsonObject());
                    part.add("abilities", (JsonElement)TCJsonUtil.merge(abilities, itemAbilities));
                }
                part.addProperty("slot", ((EquipmentSlotType)entry.getKey()).func_188450_d().toLowerCase());
                Item item = ItemParser.parse(part);
                if (item == null) continue;
                ResourceLocation id = new ResourceLocation(resourceLocation.func_110624_b(), baseId + "_" + this.toArmorName((EquipmentSlotType)entry.getKey()));
                item.setRegistryName(id);
                registry.register((IForgeRegistryEntry)item);
                ThreeCore.LOGGER.info("Registered addonpack item {}!", (Object)id);
            }
        }
        catch (Throwable throwable) {
            ThreeCore.LOGGER.error("Couldn't read addonpack suitset from {}", (Object)resourceLocation, (Object)throwable);
        }
    }

    public JsonObject convertAbilitiesSection(JsonObject jsonObject, ResourceLocation suitTag, EquipmentSlotType slotType, Map<EquipmentSlotType, ResourceLocation> armorItems) {
        jsonObject.entrySet().forEach(entry -> {
            JsonObject ability = ((JsonElement)entry.getValue()).getAsJsonObject();
            JsonArray conditions = JSONUtils.func_151213_a((JsonObject)ability, (String)"conditions", (JsonArray)new JsonArray());
            JsonObject c = new JsonObject();
            c.addProperty("type", "threecore:equipment_slot");
            c.addProperty("slot", slotType.func_188450_d());
            conditions.add((JsonElement)c);
            c = new JsonObject();
            if (suitTag == null) {
                c.addProperty("type", "threecore:wearing_item");
                for (Map.Entry entry2 : armorItems.entrySet()) {
                    JsonObject ingredient = new JsonObject();
                    ingredient.addProperty("item", ((ResourceLocation)entry2.getValue()).toString());
                    c.add(((EquipmentSlotType)entry2.getKey()).func_188450_d(), (JsonElement)ingredient);
                }
            } else {
                c.addProperty("type", "threecore:wearing_item_tag");
                c.addProperty("item_tag", suitTag.toString());
                for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                    c.addProperty(slot.func_188450_d(), Boolean.valueOf(false));
                }
                for (Map.Entry entry3 : armorItems.entrySet()) {
                    c.addProperty(((EquipmentSlotType)entry3.getKey()).func_188450_d(), Boolean.valueOf(true));
                }
            }
            conditions.add((JsonElement)c);
            ability.add("conditions", (JsonElement)conditions);
        });
        return jsonObject;
    }

    public String toArmorName(EquipmentSlotType slot) {
        switch (slot) {
            case FEET: {
                return "boots";
            }
            case LEGS: {
                return "leggings";
            }
            case CHEST: {
                return "chestplate";
            }
            case HEAD: {
                return "helmet";
            }
        }
        return null;
    }
}

