/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.addonpacks.particle;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.addonpacks.AddonPackManager;
import net.threetag.threecore.addonpacks.particle.ThreeParticle;
import net.threetag.threecore.addonpacks.particle.ThreeParticleType;

public class ParticleParser {
    public static final int resourcePrefix = "particles/".length();
    public static final int resourceSuffix = ".json".length();

    @SubscribeEvent
    public void onIParticleTypeRegistration(RegistryEvent.Register<ParticleType<?>> event) {
        IResourceManager resourceManager = AddonPackManager.getInstance().getResourceManager();
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a("particles", name -> name.endsWith(".json") && !name.startsWith("_"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation id = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(resourcePrefix, s.length() - resourceSuffix));
            try {
                IResource iresource = resourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    ParticleType<?> particleType = ParticleParser.parse((JsonObject)JSONUtils.func_193839_a((Gson)AddonPackManager.GSON, (Reader)new BufferedReader(new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8)), JsonObject.class));
                    if (particleType == null) continue;
                    particleType.setRegistryName(id);
                    event.getRegistry().register(particleType);
                    ThreeCore.LOGGER.info("Registered addonpack particleType {}!", (Object)id);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (Throwable throwable) {
                ThreeCore.LOGGER.error("Couldn't read addonpack particleType {} from {}", (Object)id, (Object)resourcelocation, (Object)throwable);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onParticleFactoryRegistration(ParticleFactoryRegisterEvent event) {
        IResourceManager resourceManager = AddonPackManager.getInstance().getResourceManager();
        LinkedHashMap particleFactories = Maps.newLinkedHashMap();
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a("particles", name -> name.endsWith(".json") && !name.startsWith("_"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation id = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(resourcePrefix, s.length() - resourceSuffix));
            try {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)((ThreeParticleType)Objects.requireNonNull(ForgeRegistries.PARTICLE_TYPES.getValue(id))), ThreeParticle.ThreeParticleFactory::new);
            }
            catch (Throwable throwable) {
                ThreeCore.LOGGER.error("Couldn't read addonpack particle factory {} from {}", (Object)id, (Object)resourcelocation, (Object)throwable);
            }
        }
    }

    public static ParticleType<?> parse(JsonObject json) throws JsonParseException {
        boolean alwaysShow = JSONUtils.func_151204_g((JsonObject)json, (String)"always_show") && JSONUtils.func_151212_i((JsonObject)json, (String)"always_show");
        Color color = new Color(1.0f, 1.0f, 1.0f);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"color")) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"color");
            color = new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
        }
        double diameter = JSONUtils.func_151204_g((JsonObject)json, (String)"diameter") ? (double)JSONUtils.func_151217_k((JsonObject)json, (String)"diameter") : 0.2;
        int maxAge = JSONUtils.func_151204_g((JsonObject)json, (String)"max_age") ? JSONUtils.func_151203_m((JsonObject)json, (String)"max_age") : 100;
        float alpha = JSONUtils.func_151204_g((JsonObject)json, (String)"alpha") ? JSONUtils.func_151217_k((JsonObject)json, (String)"alpha") : 1.0f;
        boolean canCollide = JSONUtils.func_151204_g((JsonObject)json, (String)"can_collide") && JSONUtils.func_151212_i((JsonObject)json, (String)"can_collide");
        boolean deathOnCollide = JSONUtils.func_151204_g((JsonObject)json, (String)"death_on_collide") && JSONUtils.func_151212_i((JsonObject)json, (String)"death_on_collide");
        boolean randomTexture = !JSONUtils.func_151204_g((JsonObject)json, (String)"random_texture") || JSONUtils.func_151212_i((JsonObject)json, (String)"random_texture");
        ThreeParticleType type = new ThreeParticleType(alwaysShow, color, diameter, maxAge, alpha, canCollide, deathOnCollide, randomTexture);
        return (ParticleType)Objects.requireNonNull(type);
    }
}

