/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.addonpacks.particle;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.addonpacks.particle.ThreeParticleType;

@OnlyIn(value=Dist.CLIENT)
public class ThreeParticle
extends SpriteTexturedParticle {
    public IAnimatedSprite sprites;
    public boolean deathOnCollide;
    public boolean randomTexture;

    public ThreeParticle(ClientWorld world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Color tint, double diameter, int maxAge, float alpha, boolean canCollide, boolean deathOnCollide, boolean randomTexture, IAnimatedSprite sprites) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.sprites = sprites;
        this.func_70538_b((float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f);
        this.func_187115_a((float)diameter, (float)diameter);
        float PARTICLE_SCALE_FOR_ONE_METRE = 0.5f;
        this.field_70544_f = 0.5f * (float)diameter;
        this.field_70547_e = maxAge;
        this.field_82339_as = alpha;
        this.field_187129_i = velocityX;
        this.field_187130_j = velocityY;
        this.field_187131_k = velocityZ;
        this.field_190017_n = canCollide;
        this.deathOnCollide = deathOnCollide;
        this.randomTexture = randomTexture;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (!this.randomTexture) {
            this.func_217566_b(this.sprites);
        }
        if (this.field_187132_l && this.deathOnCollide || this.field_187124_d == this.field_187127_g && this.field_187130_j > 0.0 && this.deathOnCollide || this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ThreeParticleFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprites;

        @Nullable
        public Particle makeParticle(BasicParticleType data, ClientWorld world, double xPos, double yPos, double zPos, double xVelocity, double yVelocity, double zVelocity) {
            ThreeParticleType type = (ThreeParticleType)data;
            ThreeParticle newParticle = new ThreeParticle(world, xPos, yPos, zPos, xVelocity, yVelocity, zVelocity, type.color, type.diameter, type.maxAge, type.alpha, type.canCollide, type.deathOnCollide, type.randomTexture, this.sprites);
            if (type.randomTexture) {
                newParticle.func_217568_a(this.sprites);
            } else {
                newParticle.func_217566_b(this.sprites);
            }
            return newParticle;
        }

        public ThreeParticleFactory(IAnimatedSprite sprite) {
            this.sprites = sprite;
        }
    }
}

