/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.block.MachineBlock;
import net.threetag.threecore.sound.TCSounds;
import net.threetag.threecore.tileentity.GrinderTileEntity;
import net.threetag.threecore.util.TCDamageSources;

public class GrinderBlock
extends MachineBlock {
    public GrinderBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new GrinderTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)MachineBlock.LIT)).booleanValue()) {
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.5;
            double z = (double)pos.func_177952_p() + 0.5;
            if (random.nextDouble() < 0.4) {
                world.func_184134_a(x, y, z, (SoundEvent)TCSounds.GRINDER.get(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            double x2 = random.nextDouble() * 0.8 - 0.4;
            double y2 = random.nextDouble() * 0.8;
            double z2 = random.nextDouble() * 0.8 - 0.4;
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150347_e.func_176223_P()), x + x2, y + y2, z + z2, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150351_n.func_176223_P()), x + x2, y + y2, z + z2, 0.0, 0.0, 0.0);
            if (random.nextInt(40) == 0) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x + x2, y + y2, z + z2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        float y = (float)pos.func_177956_o() + 0.5f;
        if (!world.field_72995_K && entity.func_174813_aQ().field_72338_b <= (double)y) {
            if (((Boolean)state.func_177229_b((Property)MachineBlock.LIT)).booleanValue()) {
                entity.func_70097_a(TCDamageSources.GRINDER, 2.0f);
            } else {
                double xSpeed = Math.abs(entity.func_226277_ct_() - entity.field_70142_S);
                double zSpeed = Math.abs(entity.func_226281_cx_() - entity.field_70136_U);
                if (xSpeed >= (double)0.003f || zSpeed >= (double)0.003f) {
                    entity.func_70097_a(TCDamageSources.GRINDER, 1.0f);
                }
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext selectionContext) {
        return MachineBlock.SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader blockReader, BlockPos pos) {
        return MachineBlock.INSIDE;
    }
}

