/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.capability.ISizeChanging;
import net.threetag.threecore.network.UpdateSizeData;
import net.threetag.threecore.sizechanging.SizeChangeType;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.IWrappedThreeDataHolder;
import net.threetag.threecore.util.threedata.SizeChangeTypeThreeData;
import net.threetag.threecore.util.threedata.ThreeData;
import net.threetag.threecore.util.threedata.ThreeDataManager;

public class CapabilitySizeChanging
implements ISizeChanging,
IWrappedThreeDataHolder,
INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=ISizeChanging.class)
    public static Capability<ISizeChanging> SIZE_CHANGING;
    public static final float MIN_SIZE = 0.05f;
    public static final float MAX_SIZE = 16.0f;
    public static final ThreeData<Float> SCALE;
    public static final ThreeData<Float> ESTIMATED_SCALE;
    public static final ThreeData<Float> SCALE_PER_TICK;
    public static final ThreeData<SizeChangeType> SIZE_CHANGE_TYPE;
    public final ThreeDataManager dataManager = new ThreeDataManager().setListener(new ThreeDataManager.Listener(){

        @Override
        public <T> void dataChanged(ThreeData<T> data, T oldValue, T value) {
            CapabilitySizeChanging.this.update(data, value);
        }
    });
    public final Entity entity;
    private float prevWidth = 1.0f;
    private float prevHeight = 1.0f;
    private boolean dirty = false;

    public CapabilitySizeChanging(Entity entity) {
        this.entity = entity;
        this.dataManager.register((ThreeData)SCALE, Float.valueOf(1.0f));
        this.dataManager.register((ThreeData)ESTIMATED_SCALE, Float.valueOf(1.0f));
        this.dataManager.register((ThreeData)SCALE_PER_TICK, Float.valueOf(0.0f));
        this.dataManager.register((ThreeData)SIZE_CHANGE_TYPE, (Object)SizeChangeType.DEFAULT_TYPE);
    }

    @Override
    public IThreeDataHolder getThreeDataHolder() {
        return this.dataManager;
    }

    @Override
    public void tick() {
        this.prevWidth = this.getWidth();
        this.prevHeight = this.getHeight();
        this.fixValues();
        if (this.dataManager.get(SCALE_PER_TICK).floatValue() != 0.0f) {
            this.dataManager.set((ThreeData)SCALE, Float.valueOf(this.dataManager.get(SCALE).floatValue() + this.dataManager.get(SCALE_PER_TICK).floatValue()));
            if (Math.abs(this.dataManager.get(SCALE).floatValue() - this.dataManager.get(ESTIMATED_SCALE).floatValue()) < Math.abs(this.dataManager.get(SCALE_PER_TICK).floatValue())) {
                this.dataManager.set((ThreeData)SCALE_PER_TICK, Float.valueOf(0.0f));
                this.dataManager.set((ThreeData)SCALE, this.dataManager.get(ESTIMATED_SCALE));
                this.getSizeChangeType().end(this.entity, this, this.dataManager.get(SCALE).floatValue());
            }
            this.getSizeChangeType().onSizeChanged(this.entity, this, this.dataManager.get(SCALE).floatValue());
        } else {
            this.dataManager.set((ThreeData)SCALE, this.dataManager.get(ESTIMATED_SCALE));
        }
        this.getSizeChangeType().onUpdate(this.entity, this, this.dataManager.get(SCALE).floatValue());
        if (this.getWidth() != this.prevWidth || this.getHeight() != this.prevHeight || this.dirty) {
            this.updateBoundingBox();
            this.setDirty();
            this.dirty = false;
        }
    }

    @Override
    public void updateBoundingBox() {
        boolean b = this.entity.field_70148_d;
        this.entity.field_70148_d = true;
        this.entity.func_213323_x_();
        double d0 = (double)this.entity.field_213325_aI.field_220315_a / 2.0;
        this.entity.func_174826_a(new AxisAlignedBB(this.entity.func_226277_ct_() - d0, this.entity.func_226278_cu_(), this.entity.func_226281_cx_() - d0, this.entity.func_226277_ct_() + d0, this.entity.func_226278_cu_() + (double)this.entity.field_213325_aI.field_220316_b, this.entity.func_226281_cx_() + d0));
        this.entity.field_70148_d = b;
    }

    public void fixValues() {
        if (this.dataManager.get(SCALE).floatValue() <= 0.0f) {
            this.dataManager.set((ThreeData)SCALE, Float.valueOf(1.0f));
        }
        if (this.dataManager.get(ESTIMATED_SCALE).floatValue() <= 0.0f) {
            this.dataManager.set((ThreeData)ESTIMATED_SCALE, Float.valueOf(1.0f));
        }
    }

    @Override
    public float getWidth() {
        float f = this.dataManager.get(SCALE).floatValue();
        return MathHelper.func_76131_a((float)f, (float)0.05f, (float)16.0f);
    }

    @Override
    public float getHeight() {
        float f = this.dataManager.get(SCALE).floatValue();
        if (this.entity instanceof PlayerEntity) {
            // empty if block
        }
        return MathHelper.func_76131_a((float)f, (float)0.05f, (float)16.0f);
    }

    @Override
    public float getRenderWidth(float partialTicks) {
        return this.prevWidth + (this.getWidth() - this.prevWidth) * partialTicks;
    }

    @Override
    public float getRenderHeight(float partialTicks) {
        return this.prevHeight + (this.getHeight() - this.prevHeight) * partialTicks;
    }

    @Override
    public float getScale() {
        return this.dataManager.get(SCALE).floatValue();
    }

    @Override
    public SizeChangeType getSizeChangeType() {
        return this.dataManager.get(SIZE_CHANGE_TYPE);
    }

    @Override
    public void changeSizeChangeType(SizeChangeType type) {
        if (type != null) {
            this.dataManager.set((ThreeData)SIZE_CHANGE_TYPE, (Object)type);
        }
    }

    @Override
    public boolean startSizeChange(@Nullable SizeChangeType type, float size) {
        if (size != this.dataManager.get(ESTIMATED_SCALE).floatValue()) {
            if (type != null) {
                this.dataManager.set((ThreeData)SIZE_CHANGE_TYPE, (Object)type);
            }
            if (!this.getSizeChangeType().start(this.entity, this, this.dataManager.get(SCALE).floatValue(), size)) {
                return false;
            }
            this.dataManager.set((ThreeData)ESTIMATED_SCALE, Float.valueOf(size));
            this.dataManager.set((ThreeData)SCALE_PER_TICK, Float.valueOf((size - this.dataManager.get(SCALE).floatValue()) / (float)this.getSizeChangeType().getSizeChangingTime(this.entity, this, size)));
            return true;
        }
        return false;
    }

    @Override
    public boolean setSizeDirectly(@Nullable SizeChangeType type, float size) {
        if (size != this.dataManager.get(SCALE).floatValue()) {
            this.dataManager.set((ThreeData)SCALE, Float.valueOf(size));
            this.dataManager.set((ThreeData)ESTIMATED_SCALE, Float.valueOf(size));
            this.dataManager.set((ThreeData)SCALE_PER_TICK, Float.valueOf(0.0f));
            if (type != null) {
                this.dataManager.set((ThreeData)SIZE_CHANGE_TYPE, (Object)type);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSizeChanging() {
        return this.dataManager.get(SCALE_PER_TICK).floatValue() != 0.0f;
    }

    public <T> void update(ThreeData<T> data, T value) {
        this.setDirty();
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        data.writeToNBT(nbt, value);
        if (data.getSyncType() != EnumSync.NONE && this.entity instanceof ServerPlayerEntity) {
            ThreeCore.NETWORK_CHANNEL.sendTo((Object)new UpdateSizeData(this.entity.func_145782_y(), data.getKey(), nbt), ((ServerPlayerEntity)this.entity).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
        if (data.getSyncType() == EnumSync.EVERYONE && this.entity.field_70170_p instanceof ServerWorld) {
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.entity), (Object)new UpdateSizeData(this.entity.func_145782_y(), data.getKey(), nbt));
        }
    }

    public void setDirty() {
        this.dirty = true;
    }

    public CompoundNBT serializeNBT() {
        return this.dataManager.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.dataManager.deserializeNBT(nbt);
    }

    static {
        SCALE = new FloatThreeData("scale").setSyncType(EnumSync.NONE);
        ESTIMATED_SCALE = new FloatThreeData("estimated_scale");
        SCALE_PER_TICK = new FloatThreeData("scale_per_tick");
        SIZE_CHANGE_TYPE = new SizeChangeTypeThreeData("size_change_type");
    }
}

