/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.ISizeChanging;

public class SizeChangingProvider
implements ICapabilitySerializable<CompoundNBT> {
    public final ISizeChanging container;
    private LazyOptional<ISizeChanging> optional;

    public SizeChangingProvider(ISizeChanging container) {
        this.container = container;
        this.optional = LazyOptional.of(() -> container);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilitySizeChanging.SIZE_CHANGING) {
            return this.optional;
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (this.container instanceof INBTSerializable) {
            return (CompoundNBT)((INBTSerializable)this.container).serializeNBT();
        }
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.container instanceof INBTSerializable) {
            ((INBTSerializable)this.container).deserializeNBT((INBT)nbt);
        }
    }
}

