/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.gui.ability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.client.gui.ability.AbilityTabEntry;
import net.threetag.threecore.client.gui.ability.AbilityTabGui;

public class AbilitiesScreen
extends Screen {
    public static final ResourceLocation WINDOW = new ResourceLocation("threecore", "textures/gui/abilities/window.png");
    public static final ResourceLocation TABS = new ResourceLocation("threecore", "textures/gui/abilities/tabs.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("threecore", "textures/gui/abilities/widgets.png");
    private final int guiWidth = 252;
    private final int guiHeight = 196;
    private List<AbilityTabGui> tabs = Lists.newLinkedList();
    private AbilityTabGui selectedTab = null;
    public Screen overlayScreen = null;
    private boolean isScrolling;

    public AbilitiesScreen() {
        super(NarratorChatListener.field_216868_a);
        this.tabs.clear();
        this.selectedTab = null;
        AtomicInteger index = new AtomicInteger();
        AbilityHelper.getAbilityContainers((LivingEntity)Minecraft.func_71410_x().field_71439_g).forEach(container -> {
            if (!container.getAbilities().isEmpty()) {
                this.tabs.add(AbilityTabGui.create(Minecraft.func_71410_x(), this, index.get(), container));
                index.getAndIncrement();
            }
        });
        if (!this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(0);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.overlayScreen != null) {
            this.overlayScreen.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int type) {
        if (type == 0) {
            AbilityTabEntry entry;
            int i = (this.field_230708_k_ - 252) / 2;
            int j = (this.field_230709_l_ - 196) / 2;
            if (this.isOverOverlayScreen(mouseX, mouseY)) {
                return this.overlayScreen.func_231044_a_(mouseX, mouseY, type);
            }
            for (AbilityTabGui tab : this.tabs) {
                if (!tab.isMouseOver(i, j, mouseX, mouseY)) continue;
                this.selectedTab = tab;
                break;
            }
            if (this.selectedTab != null && (entry = this.selectedTab.getAbilityHoveredOver((int)(mouseX - (double)i - 9.0), (int)(mouseY - (double)j - 18.0), i, j)) != null) {
                this.overlayScreen = entry.getScreen(this);
                if (this.overlayScreen != null) {
                    this.overlayScreen.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, type);
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double x, double y) {
        if (p_mouseDragged_5_ != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(x, y);
        }
        return true;
    }

    public boolean func_231046_a_(int type, int scanCode, int modifiers) {
        return this.overlayScreen == null ? super.func_231046_a_(type, scanCode, modifiers) : this.overlayScreen.func_231046_a_(type, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        int i = (this.field_230708_k_ - 252) / 2;
        int j = (this.field_230709_l_ - 196) / 2;
        this.func_230446_a_(stack);
        this.renderInside(stack, mouseX, mouseY, i, j);
        this.renderWindow(stack, i, j);
        this.renderToolTips(stack, mouseX, mouseY, i, j);
        if (this.overlayScreen != null) {
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
            this.overlayScreen.func_230430_a_(stack, mouseX, mouseY, partialTicks);
            this.selectedTab.fade = MathHelper.func_76131_a((float)(this.selectedTab.fade + 0.02f), (float)0.0f, (float)0.5f);
            RenderSystem.popMatrix();
        }
    }

    public void renderWindow(MatrixStack stack, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.getMinecraft().func_110434_K().func_110577_a(WINDOW);
        this.func_238474_b_(stack, x, y, 0, 0, 252, 196);
        if (this.tabs.size() > 0) {
            this.getMinecraft().func_110434_K().func_110577_a(TABS);
            for (AbilityTabGui tab : this.tabs) {
                tab.drawTab(stack, x, y, tab == this.selectedTab);
            }
            RenderSystem.enableRescaleNormal();
            RenderSystem.defaultBlendFunc();
            for (AbilityTabGui tab : this.tabs) {
                tab.drawIcon(stack, x, y);
            }
            RenderSystem.disableBlend();
        }
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new TranslationTextComponent("gui.threecore.abilities"), (float)(x + 8), (float)(y + 6), 0x404040);
    }

    private void renderInside(MatrixStack stack, int mouseX, int mouseY, int x, int y) {
        AbilityTabGui tab = this.selectedTab;
        if (tab == null) {
            AbilitiesScreen.func_238467_a_((MatrixStack)stack, (int)(x + 9), (int)(y + 18), (int)(x + 9 + 234), (int)(y + 18 + 169), (int)-16777216);
            TranslationTextComponent s = new TranslationTextComponent("advancements.empty");
            int i = this.field_230712_o_.func_78256_a(s.getString());
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)s, (float)(x + 9 + 117 - i / 2), (float)(y + 18 + 56 - 4), -1);
            this.field_230712_o_.func_243248_b(stack, (ITextComponent)new StringTextComponent(":("), (float)(x + 9 + 117 - this.field_230712_o_.func_78256_a(":(") / 2), (float)(y + 18 + 113 - 9), -1);
        } else {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)((double)x + 9.0), (double)((double)y + 18.0), (double)0.0);
            RenderSystem.enableDepthTest();
            tab.drawContents(stack);
            RenderSystem.popMatrix();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        }
    }

    private void renderToolTips(MatrixStack stack, int mouseX, int mouseY, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.translated((double)(x + 9), (double)(y + 18), (double)400.0);
            this.selectedTab.drawToolTips(stack, mouseX - x - 9, mouseY - y - 18, x, y, this, this.overlayScreen != null);
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
        }
        if (this.overlayScreen == null && this.tabs.size() > 0) {
            for (AbilityTabGui tab : this.tabs) {
                if (!tab.isMouseOver(x, y, mouseX, mouseY)) continue;
                this.func_238652_a_(stack, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public boolean isOverOverlayScreen(double mouseX, double mouseY) {
        return this.overlayScreen != null;
    }
}

