/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.gui.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.threetag.threecore.container.MultiversalIteratorContainer;
import net.threetag.threecore.item.MultiversalExtrapolatorItem;
import net.threetag.threecore.sound.TCSounds;

public class MultiversalIteratorScreen
extends ContainerScreen<MultiversalIteratorContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("threecore", "textures/gui/container/multiversal_iterator.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public MultiversalIteratorScreen(MultiversalIteratorContainer containerIn, PlayerInventory playerInv, ITextComponent titleIn) {
        super((Container)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        this.field_147000_g = 198;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(stack, mouseX, mouseY);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (!MultiversalExtrapolatorItem.hasValidUniverseClient(((MultiversalIteratorContainer)this.field_147002_h).func_75139_a(0).func_75211_c()) && this.getMinecraft() != null && this.getMinecraft().field_71439_g != null && this.getMinecraft().field_71439_g.field_70173_aa % 2 == 0) {
            this.getMinecraft().field_71439_g.func_184185_a((SoundEvent)TCSounds.MULTIVERSE_SEARCH.get(), 0.5f, 1.0f);
        }
    }

    protected void func_230451_b_(MatrixStack stack, int mouseX, int mouseY) {
        super.func_230451_b_(stack, mouseX, mouseY);
        Random random = new Random(this.getMinecraft().field_71439_g.field_70173_aa / 2);
        String s = MultiversalExtrapolatorItem.hasValidUniverseClient(((MultiversalIteratorContainer)this.field_147002_h).func_75139_a(0).func_75211_c()) ? TextFormatting.GOLD + I18n.func_135052_a((String)("universe." + ((MultiversalIteratorContainer)this.field_147002_h).func_75139_a(0).func_75211_c().func_196082_o().func_74779_i("Universe")), (Object[])new Object[0]) : I18n.func_135052_a((String)"universe.earth_search", (Object[])new Object[]{random.nextInt(10) + "" + random.nextInt(10) + "" + random.nextInt(10)});
        this.field_230712_o_.func_238421_b_(stack, s, (float)this.field_146999_f / 2.0f - (float)this.field_230712_o_.func_78256_a(s) / 2.0f, 25.0f, 0xFFFFFF);
    }

    protected void func_230450_a_(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(stack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(stack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (int)(41.0f * this.sliderProgress);
        this.func_238474_b_(stack, i + 119, j + 47 + k, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.field_147003_i + 52;
        int i1 = this.field_147009_r + 46;
        int j1 = this.recipeIndexOffset + 12;
        this.drawRecipesBackground(stack, mouseX, mouseY, l, i1, j1);
        this.drawRecipesItems(l, i1, j1);
    }

    private void drawRecipesBackground(MatrixStack stack, int mouseX, int mouseY, int left, int top, int recipeIndexOffsetMax) {
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((MultiversalIteratorContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((MultiversalIteratorContainer)this.field_147002_h).getSelectedRecipe()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            this.func_238474_b_(stack, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        List<ItemStack> list = ((MultiversalIteratorContainer)this.field_147002_h).getItemList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((MultiversalIteratorContainer)this.field_147002_h).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            this.getMinecraft().func_175599_af().func_180450_b(list.get(i), k, i1);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int type) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((MultiversalIteratorContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.getMinecraft().field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((SoundEvent)TCSounds.MULTIVERSE_SEARCH.get()), (float)1.0f));
                this.getMinecraft().field_71442_b.func_78756_a(((MultiversalIteratorContainer)this.field_147002_h).field_75152_c, l);
                return true;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, type);
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.clickedOnSroll && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)p_mouseDragged_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.func_231045_a_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - p_mouseScrolled_5_ / (double)i);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((MultiversalIteratorContainer)this.field_147002_h).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((MultiversalIteratorContainer)this.field_147002_h).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((MultiversalIteratorContainer)this.field_147002_h).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

