/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.SkinChangeAbility;

public class PlayerSkinHandler {
    private static List<Pair<Integer, ISkinProvider>> PROVIDER = Lists.newLinkedList();

    public static ResourceLocation getCurrentSkin(GameProfile gameProfile, ResourceLocation defaultSkin) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)Minecraft.func_71410_x().field_71441_e.func_217371_b(gameProfile.getId());
        if (player != null) {
            ResourceLocation start = defaultSkin;
            for (Pair<Integer, ISkinProvider> pair : PROVIDER) {
                start = ((ISkinProvider)pair.getSecond()).getSkin(player, start, defaultSkin);
            }
            return start;
        }
        return defaultSkin;
    }

    public static void registerSkinProvider(int priority, ISkinProvider provider) {
        PROVIDER.add((Pair<Integer, ISkinProvider>)Pair.of((Object)priority, (Object)provider));
        PROVIDER.sort((p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst());
    }

    static {
        PlayerSkinHandler.registerSkinProvider(30, (player, previousSkin, defaultSkin) -> {
            List abilities = AbilityHelper.getAbilitiesFromClass((LivingEntity)player, SkinChangeAbility.class).stream().filter(a -> a.getConditionManager().isEnabled()).sorted((a1, a2) -> (Integer)a2.get(SkinChangeAbility.PRIORITY) - (Integer)a1.get(SkinChangeAbility.PRIORITY)).collect(Collectors.toList());
            if (abilities.size() > 0) {
                return (ResourceLocation)((SkinChangeAbility)abilities.get(0)).get(SkinChangeAbility.TEXTURE);
            }
            return previousSkin;
        });
    }

    public static interface ISkinProvider {
        public ResourceLocation getSkin(AbstractClientPlayerEntity var1, ResourceLocation var2, ResourceLocation var3);
    }
}

