/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.ModelLayerTexture;
import net.threetag.threecore.util.RenderUtil;

public class CapeModelLayer
implements IModelLayer {
    public final ModelLayerTexture texture;
    public final List<IModelLayerPredicate> glowPredicates;
    public final List<IModelLayerPredicate> predicateList = Lists.newLinkedList();

    public CapeModelLayer(ModelLayerTexture texture) {
        this.texture = texture;
        this.glowPredicates = Collections.emptyList();
    }

    public CapeModelLayer(ModelLayerTexture texture, List<IModelLayerPredicate> glowPredicates) {
        this.texture = texture;
        this.glowPredicates = glowPredicates;
    }

    @Override
    public void render(IModelLayerContext context, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, @Nullable IEntityRenderer<? extends Entity, ? extends EntityModel<?>> entityRenderer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityRenderer != null && entityRenderer.func_217764_d() instanceof BipedModel && context.getAsEntity() instanceof LivingEntity) {
            if (((LivingEntity)context.getAsEntity()).func_184582_a(EquipmentSlotType.CHEST).func_77973_b() instanceof ElytraItem) {
                return;
            }
            if (context.getAsEntity() instanceof ClientPlayerEntity && ((PlayerEntity)context.getAsEntity()).func_175148_a(PlayerModelPart.CAPE) && ((ClientPlayerEntity)context.getAsEntity()).func_110303_q() != null) {
                return;
            }
            matrixStack.func_227860_a_();
            float rotation = 0.0f;
            if (context.getAsEntity() instanceof LivingEntity && ((LivingEntity)context.getAsEntity()).func_184613_cA()) {
                rotation = 0.0f;
            } else if (context.getAsEntity() instanceof PlayerEntity) {
                PlayerEntity entity = (PlayerEntity)context.getAsEntity();
                double d0 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_71091_bM, (double)entity.field_71094_bP) - MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.func_226277_ct_());
                double d1 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_71096_bN, (double)entity.field_71095_bQ) - MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70167_r, (double)entity.func_226278_cu_());
                double d2 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_71097_bO, (double)entity.field_71085_bR) - MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.func_226281_cx_());
                float f = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar);
                double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
                double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                if ((f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f)) < 0.0f) {
                    f2 = 0.0f;
                }
                float f4 = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_71107_bF, (float)entity.field_71109_bG);
                rotation = 6.0f + f2 / 2.0f + (f1 += MathHelper.func_76126_a((float)(MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70141_P, (float)entity.field_70140_Q) * 6.0f)) * 32.0f * f4);
            }
            ((BipedModel)entityRenderer.func_217764_d()).field_78115_e.func_228307_a_(matrixStack);
            matrixStack.func_227861_a_(0.0, (double)-0.02f, (double)0.2f);
            IVertexBuilder vertex = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderType.func_228644_e_((ResourceLocation)this.texture.getTexture(context)), (boolean)false, (context.getAsItem() != null && context.getAsItem().func_77962_s() ? 1 : 0) != 0);
            int color = this.getColor(context);
            if (color > -1) {
                this.renderCape(context, matrixStack, vertex, rotation, RenderUtil.red(color), RenderUtil.green(color), RenderUtil.blue(color), packedLight, partialTicks);
            } else {
                this.renderCape(context, matrixStack, vertex, rotation, 255, 255, 255, packedLight, partialTicks);
            }
            matrixStack.func_227865_b_();
        }
    }

    public int getColor(IModelLayerContext context) {
        return -1;
    }

    public void renderCape(IModelLayerContext context, MatrixStack matrixStack, IVertexBuilder vertex, float rotation, int red, int green, int blue, int packedLight, float partialTicks) {
        this.drawVertex(matrixStack, vertex, 0.4f, 0.0f, 0.0f, 0.0f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 0.0f, 0.0f, 0.21875f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 0.0f, -0.4f, 0.21875f, 0.0f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, 0.4f, 0.0f, -0.4f, 0.0f, 0.0f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, 0.4f, 1.0E-4f, 0.0f, 0.21875f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 1.0E-4f, 0.0f, 0.4375f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 1.0E-4f, -0.4f, 0.4375f, 0.0f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, 0.4f, 1.0E-4f, -0.4f, 0.21875f, 0.0f, 0, 1, 0, packedLight, red, green, blue);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotation));
        this.drawVertex(matrixStack, vertex, 0.4f, 0.0f, 0.0f, 0.0f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 0.0f, 0.0f, 0.21875f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 1.2f, 0.0f, 0.21875f, 1.0f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, 0.4f, 1.2f, 0.0f, 0.0f, 1.0f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, 0.4f, 0.0f, -1.0E-4f, 0.21875f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 0.0f, -1.0E-4f, 0.4375f, 0.25f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, -0.4f, 1.2f, -1.0E-4f, 0.4375f, 1.0f, 0, 1, 0, packedLight, red, green, blue);
        this.drawVertex(matrixStack, vertex, 0.4f, 1.2f, -1.0E-4f, 0.21875f, 1.0f, 0, 1, 0, packedLight, red, green, blue);
    }

    public void drawVertex(MatrixStack matrixStack, IVertexBuilder vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, int normalX, int normalY, int normalZ, int packedLightIn, int red, int green, int blue) {
        vertexBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), offsetX, offsetY, offsetZ).func_225586_a_(red, green, blue, 255).func_225583_a_(textureX, textureY).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLightIn).func_227887_a_(matrixStack.func_227866_c_().func_227872_b_(), (float)normalX, (float)normalZ, (float)normalY).func_181675_d();
    }

    @Override
    public boolean isActive(IModelLayerContext context) {
        return ModelLayerManager.arePredicatesFulFilled(this.predicateList, context);
    }

    @Override
    public CapeModelLayer addPredicate(IModelLayerPredicate predicate) {
        this.predicateList.add(predicate);
        return this;
    }

    public static CapeModelLayer parse(JsonObject json) {
        LinkedList glowPredicates = Lists.newLinkedList();
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"glow")) {
            JsonElement glowJson = json.get("glow");
            if (glowJson.isJsonPrimitive() && glowJson.getAsBoolean()) {
                glowPredicates.add(c -> true);
            } else {
                JsonArray predicateArray = JSONUtils.func_151214_t((JsonObject)json, (String)"glow");
                for (int i = 0; i < predicateArray.size(); ++i) {
                    IModelLayerPredicate predicate = ModelLayerManager.parsePredicate(predicateArray.get(i).getAsJsonObject());
                    if (predicate == null) continue;
                    glowPredicates.add(predicate);
                }
            }
        } else {
            glowPredicates.add(c -> false);
        }
        return new CapeModelLayer(ModelLayerTexture.parse(json.get("texture")), glowPredicates);
    }
}

