/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fml.ModList;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.client.renderer.entity.modellayer.CapeModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.CompoundModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerProvider;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerLoader;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.EntityTagPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.EntityTypePredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.FlyingPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IntegerNbtPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IsSizeChangingPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.ItemDurabilityPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.KarmaPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.NotPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.OrPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.SizePredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.DefaultModelTexture;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.ModelLayerTexture;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer.AlphaMaskTextureTransformer;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer.ITextureTransformer;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer.OverlayTextureTransformer;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.variable.AbilityDataTextureVariable;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.variable.EntityTicksTextureVariable;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.variable.ITextureVariable;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.variable.IntegerNbtTextureVariable;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.variable.SmallArmsTextureVariable;
import net.threetag.threecore.compat.curios.DefaultCuriosHandler;
import net.threetag.threecore.util.PlayerUtil;

public class ModelLayerManager {
    public static List<Function<LivingEntity, List<Pair<IModelLayer, IModelLayerContext>>>> MODEL_LAYER_PROVIDERS = Lists.newArrayList();
    private static final Map<ResourceLocation, NonNullFunction<JsonObject, IModelLayerPredicate>> PREDICATES = Maps.newHashMap();
    private static final Map<ResourceLocation, NonNullFunction<JsonObject, IModelLayer>> MODEL_LAYERS = Maps.newHashMap();
    private static final Map<ResourceLocation, NonNullFunction<JsonObject, ModelLayerTexture>> MODEL_LAYER_TEXTURES = Maps.newHashMap();
    private static final Map<ResourceLocation, NonNullFunction<JsonObject, ITextureVariable>> TEXTURE_VARIABLES = Maps.newHashMap();
    private static final Map<ResourceLocation, NonNullFunction<JsonObject, ITextureTransformer>> TEXTURE_TRANSFORMERS = Maps.newHashMap();

    public static List<Function<LivingEntity, List<Pair<IModelLayer, IModelLayerContext>>>> getModelLayerProviders() {
        return MODEL_LAYER_PROVIDERS;
    }

    public static void forEachLayer(LivingEntity entity, BiConsumer<IModelLayer, IModelLayerContext> consumer) {
        List<Function<LivingEntity, List<Pair<IModelLayer, IModelLayerContext>>>> providers = ModelLayerManager.getModelLayerProviders();
        for (Function<LivingEntity, List<Pair<IModelLayer, IModelLayerContext>>> function : providers) {
            List<Pair<IModelLayer, IModelLayerContext>> layers = function.apply(entity);
            for (Pair<IModelLayer, IModelLayerContext> pair : layers) {
                consumer.accept((IModelLayer)pair.getFirst(), (IModelLayerContext)pair.getSecond());
            }
        }
    }

    public static void registerLayerProvider(Function<LivingEntity, List<Pair<IModelLayer, IModelLayerContext>>> function) {
        Preconditions.checkNotNull(function);
        MODEL_LAYER_PROVIDERS.add(function);
    }

    public static void registerPredicate(ResourceLocation id, NonNullFunction<JsonObject, IModelLayerPredicate> function) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull(function);
        PREDICATES.put(id, function);
    }

    public static void registerModelLayer(ResourceLocation id, NonNullFunction<JsonObject, IModelLayer> function) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull(function);
        MODEL_LAYERS.put(id, function);
    }

    public static void registerModelTexture(ResourceLocation id, NonNullFunction<JsonObject, ModelLayerTexture> function) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull(function);
        MODEL_LAYER_TEXTURES.put(id, function);
    }

    public static void registerTextureVariable(ResourceLocation id, NonNullFunction<JsonObject, ITextureVariable> textureVariable) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull(textureVariable);
        TEXTURE_VARIABLES.put(id, textureVariable);
    }

    public static void registerTextureTransformer(ResourceLocation id, NonNullFunction<JsonObject, ITextureTransformer> function) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull(function);
        TEXTURE_TRANSFORMERS.put(id, function);
    }

    public static ModelLayerTexture parseTexture(JsonObject jsonObject) {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"type", (String)"threecore:default"));
        NonNullFunction<JsonObject, ModelLayerTexture> function = MODEL_LAYER_TEXTURES.get(id);
        return function != null ? (ModelLayerTexture)function.apply((Object)jsonObject) : null;
    }

    public static ITextureTransformer parseTextureTransformer(JsonObject jsonObject) {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type"));
        NonNullFunction<JsonObject, ITextureTransformer> function = TEXTURE_TRANSFORMERS.get(id);
        return function != null ? (ITextureTransformer)function.apply((Object)jsonObject) : null;
    }

    public static ITextureVariable parseTextureVariable(JsonObject jsonObject) {
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"type"));
        NonNullFunction<JsonObject, ITextureVariable> function = TEXTURE_VARIABLES.get(id);
        return function != null ? (ITextureVariable)function.apply((Object)jsonObject) : null;
    }

    public static IModelLayerPredicate parsePredicate(JsonObject json) {
        NonNullFunction<JsonObject, IModelLayerPredicate> function = PREDICATES.get(new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)"")));
        return function != null ? (IModelLayerPredicate)function.apply((Object)json) : null;
    }

    public static IModelLayer parseLayer(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return ModelLayerLoader.getModelLayer(new ResourceLocation(jsonElement.getAsString()));
        }
        JsonObject json = jsonElement.getAsJsonObject();
        NonNullFunction<JsonObject, IModelLayer> function = MODEL_LAYERS.get(new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)"threecore:default")));
        if (function == null) {
            return null;
        }
        IModelLayer layer = (IModelLayer)function.apply((Object)json);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"predicates")) {
            JsonArray predicateArray = JSONUtils.func_151214_t((JsonObject)json, (String)"predicates");
            for (int i = 0; i < predicateArray.size(); ++i) {
                IModelLayerPredicate predicate = ModelLayerManager.parsePredicate(predicateArray.get(i).getAsJsonObject());
                if (predicate == null) continue;
                layer.addPredicate(predicate);
            }
        }
        return layer;
    }

    public static boolean arePredicatesFulFilled(List<IModelLayerPredicate> predicates, IModelLayerContext context) {
        for (IModelLayerPredicate predicate : predicates) {
            if (predicate.test(context)) continue;
            return false;
        }
        return true;
    }

    static {
        ModelLayerManager.registerLayerProvider(entity -> {
            ArrayList list = Lists.newArrayList();
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack;
                if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || !((stack = entity.func_184582_a(slot)).func_77973_b() instanceof IModelLayerProvider)) continue;
                ModelLayerContext context = new ModelLayerContext((LivingEntity)entity, stack, slot);
                for (IModelLayer layer : ((IModelLayerProvider)stack.func_77973_b()).getModelLayers(context)) {
                    list.add(Pair.of((Object)layer, (Object)context));
                }
            }
            return list;
        });
        ModelLayerManager.registerLayerProvider(entity -> {
            ModelLayerContext context = new ModelLayerContext((Entity)entity);
            ArrayList list = Lists.newArrayList();
            for (Ability ability : AbilityHelper.getAbilities(entity)) {
                if (!(ability instanceof IModelLayerProvider)) continue;
                for (IModelLayer layer : ((IModelLayerProvider)((Object)ability)).getModelLayers(context)) {
                    list.add(Pair.of((Object)layer, (Object)context));
                }
            }
            return list;
        });
        if (ModList.get().isLoaded("curios")) {
            ModelLayerManager.registerLayerProvider(entity -> {
                ArrayList list = Lists.newArrayList();
                for (String id : DefaultCuriosHandler.INSTANCE.getSlotTypeIds()) {
                    for (ItemStack stack : DefaultCuriosHandler.INSTANCE.getItemsInSlot((LivingEntity)entity, id)) {
                        if (!(stack.func_77973_b() instanceof IModelLayerProvider)) continue;
                        ModelLayerContext context = new ModelLayerContext((Entity)entity, stack);
                        for (IModelLayer layer : ((IModelLayerProvider)stack.func_77973_b()).getModelLayers(context)) {
                            list.add(Pair.of((Object)layer, (Object)context));
                        }
                    }
                }
                return list;
            });
        }
        ModelLayerManager.registerModelLayer(new ResourceLocation("threecore", "default"), (NonNullFunction<JsonObject, IModelLayer>)((NonNullFunction)ModelLayer::parse));
        ModelLayerManager.registerModelLayer(new ResourceLocation("threecore", "compound"), (NonNullFunction<JsonObject, IModelLayer>)((NonNullFunction)CompoundModelLayer::parse));
        ModelLayerManager.registerModelLayer(new ResourceLocation("threecore", "cape"), (NonNullFunction<JsonObject, IModelLayer>)((NonNullFunction)CapeModelLayer::parse));
        ModelLayerManager.registerModelTexture(new ResourceLocation("threecore", "default"), (NonNullFunction<JsonObject, ModelLayerTexture>)((NonNullFunction)j -> {
            DefaultModelTexture texture = new DefaultModelTexture(JSONUtils.func_151200_h((JsonObject)j, (String)"base"), JSONUtils.func_151219_a((JsonObject)j, (String)"output", (String)""));
            if (JSONUtils.func_151204_g((JsonObject)j, (String)"variables")) {
                JsonObject variables = JSONUtils.func_152754_s((JsonObject)j, (String)"variables");
                variables.entrySet().forEach(e -> {
                    ITextureVariable textureVariable = ModelLayerManager.parseTextureVariable(((JsonElement)e.getValue()).getAsJsonObject());
                    if (textureVariable != null) {
                        texture.addVariable((String)e.getKey(), textureVariable);
                    } else {
                        ThreeCore.LOGGER.warn("Texture variable type '" + JSONUtils.func_151200_h((JsonObject)((JsonElement)e.getValue()).getAsJsonObject(), (String)"type") + "' does not exist!");
                    }
                });
            }
            return texture;
        }));
        ModelLayerManager.registerTextureTransformer(new ResourceLocation("threecore", "alpha_mask"), (NonNullFunction<JsonObject, ITextureTransformer>)((NonNullFunction)j -> new AlphaMaskTextureTransformer(JSONUtils.func_151200_h((JsonObject)j, (String)"mask"))));
        ModelLayerManager.registerTextureTransformer(new ResourceLocation("threecore", "overlay"), (NonNullFunction<JsonObject, ITextureTransformer>)((NonNullFunction)j -> new OverlayTextureTransformer(JSONUtils.func_151200_h((JsonObject)j, (String)"overlay"))));
        ModelLayerManager.registerTextureVariable(new ResourceLocation("threecore", "entity_ticks"), (NonNullFunction<JsonObject, ITextureVariable>)((NonNullFunction)EntityTicksTextureVariable::new));
        ModelLayerManager.registerTextureVariable(new ResourceLocation("threecore", "integer_nbt"), (NonNullFunction<JsonObject, ITextureVariable>)((NonNullFunction)j -> new IntegerNbtTextureVariable(JSONUtils.func_151200_h((JsonObject)j, (String)"nbt_tag"), (JsonObject)j)));
        ModelLayerManager.registerTextureVariable(new ResourceLocation("threecore", "small_arms"), (NonNullFunction<JsonObject, ITextureVariable>)((NonNullFunction)j -> new SmallArmsTextureVariable(JSONUtils.func_151219_a((JsonObject)j, (String)"normal_arms_value", null), JSONUtils.func_151219_a((JsonObject)j, (String)"small_arms_value", null))));
        ModelLayerManager.registerTextureVariable(new ResourceLocation("threecore", "ability_data"), (NonNullFunction<JsonObject, ITextureVariable>)((NonNullFunction)AbilityDataTextureVariable::new));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "not"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new NotPredicate(ModelLayerManager.parsePredicate(JSONUtils.func_152754_s((JsonObject)j, (String)"predicate")))));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "or"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)OrPredicate::parse));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "sneaking"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> context -> context.getAsEntity().func_213453_ef()));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "durability"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new ItemDurabilityPredicate(JSONUtils.func_151221_a((JsonObject)j, (String)"min", (float)0.0f), JSONUtils.func_151221_a((JsonObject)j, (String)"max", (float)1.0f))));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "small_arms"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> c -> c.getAsEntity() instanceof PlayerEntity && PlayerUtil.hasSmallArms((PlayerEntity)c.getAsEntity())));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "is_size_changing"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new IsSizeChangingPredicate()));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "size"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new SizePredicate(JSONUtils.func_151221_a((JsonObject)j, (String)"min", (float)1.0f), JSONUtils.func_151221_a((JsonObject)j, (String)"max", (float)1.0f))));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "karma"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new KarmaPredicate(JSONUtils.func_151208_a((JsonObject)j, (String)"min", (int)0), JSONUtils.func_151208_a((JsonObject)j, (String)"max", (int)0))));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "integer_nbt"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)IntegerNbtPredicate::parse));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "flying"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new FlyingPredicate()));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "entity_type"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new EntityTypePredicate(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)j, (String)"entity_type")))));
        ModelLayerManager.registerPredicate(new ResourceLocation("threecore", "entity_tag"), (NonNullFunction<JsonObject, IModelLayerPredicate>)((NonNullFunction)j -> new EntityTagPredicate(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)j, (String)"entity_tag")))));
    }
}

