/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.sizechanging.SizeChangeType;

public class SizeChangeCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_SIZE_CHANGES_TYPES = (context, builder) -> {
        Collection sizeChangeTypes = SizeChangeType.REGISTRY.getValues();
        return ISuggestionProvider.func_212476_a(sizeChangeTypes.stream().map(ForgeRegistryEntry::getRegistryName), (SuggestionsBuilder)builder);
    };
    public static final DynamicCommandExceptionType SIZE_CHANGE_TYPE_NOT_FOUND = new DynamicCommandExceptionType(object -> new TranslationTextComponent("commands.sizechange.error.sizeChangeTypeNotFound", new Object[]{object}));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sizechange").requires(sender -> sender.func_197034_c(2))).then(Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.05f, (float)16.0f)).executes(c -> SizeChangeCommand.setScale((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), FloatArgumentType.getFloat((CommandContext)c, (String)"scale"), null))).then(Commands.func_197056_a((String)"size_change_type", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_SIZE_CHANGES_TYPES).executes(c -> SizeChangeCommand.setScale((CommandSource)c.getSource(), EntityArgument.func_197097_b((CommandContext)c, (String)"entities"), FloatArgumentType.getFloat((CommandContext)c, (String)"scale"), SizeChangeCommand.getSizeChangeType((CommandContext<CommandSource>)c, "size_change_type")))))));
    }

    private static int setScale(CommandSource commandSource, Collection<? extends Entity> entities, float scale, @Nullable SizeChangeType sizeChangeType) {
        AtomicInteger result = new AtomicInteger(0);
        entities.forEach(e -> e.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            if (sizeChanging.startSizeChange(sizeChangeType, scale)) {
                result.incrementAndGet();
            }
        }));
        if (result.get() == 1) {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.sizechange.success.entity.single", new Object[]{entities.iterator().next().func_145748_c_(), Float.valueOf(scale), sizeChangeType == null ? SizeChangeType.DEFAULT_TYPE.getRegistryName() : sizeChangeType.getRegistryName()}), true);
        } else {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.sizechange.success.entity.multiple", new Object[]{result.get(), Float.valueOf(scale), sizeChangeType == null ? SizeChangeType.DEFAULT_TYPE.getRegistryName() : sizeChangeType.getRegistryName()}), true);
        }
        return result.get();
    }

    public static SizeChangeType getSizeChangeType(CommandContext<CommandSource> context, String key) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)context.getArgument(key, ResourceLocation.class);
        SizeChangeType sizeChangeType = (SizeChangeType)SizeChangeType.REGISTRY.getValue(resourceLocation);
        if (sizeChangeType == null) {
            throw SIZE_CHANGE_TYPE_NOT_FOUND.create((Object)resourceLocation);
        }
        return sizeChangeType;
    }
}

