/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.compat.jei;

import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.client.gui.inventory.ConstructionTableScreen;
import net.threetag.threecore.client.gui.inventory.FluidComposerScreen;
import net.threetag.threecore.client.gui.inventory.GrinderScreen;
import net.threetag.threecore.client.gui.inventory.HydraulicPressScreen;
import net.threetag.threecore.compat.jei.ThreeCoreRecipeFactory;
import net.threetag.threecore.compat.jei.constructiontable.BootsCraftingCategory;
import net.threetag.threecore.compat.jei.constructiontable.ChestplateCraftingCategory;
import net.threetag.threecore.compat.jei.constructiontable.HelmetCraftingCategory;
import net.threetag.threecore.compat.jei.constructiontable.LeggingsCraftingCategory;
import net.threetag.threecore.compat.jei.fluidcomposing.FluidComposingCategory;
import net.threetag.threecore.compat.jei.grinding.GrindingCategory;
import net.threetag.threecore.compat.jei.pressing.PressingCategory;
import net.threetag.threecore.container.AbstractConstructionTableContainer;
import net.threetag.threecore.container.BootsCraftingContainer;
import net.threetag.threecore.container.ChestplateCraftingContainer;
import net.threetag.threecore.container.FluidComposerContainer;
import net.threetag.threecore.container.GrinderContainer;
import net.threetag.threecore.container.HelmetCraftingContainer;
import net.threetag.threecore.container.HydraulicPressContainer;
import net.threetag.threecore.container.LeggingsCraftingContainer;
import net.threetag.threecore.item.recipe.AbstractConstructionTableRecipe;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;

@JeiPlugin
public class ThreeCoreJEIPlugin
implements IModPlugin {
    public static final ResourceLocation RECIPE_GUI_TEXTURE = new ResourceLocation("threecore", "textures/gui/jei.png");
    public static final ResourceLocation HELMET_CRAFTING_CATEGORY = new ResourceLocation("threecore", "helmet_crafting");
    public static final ResourceLocation CHESTPLATE_CRAFTING_CATEGORY = new ResourceLocation("threecore", "chestplate_crafting");
    public static final ResourceLocation LEGGINGS_CRAFTING_CATEGORY = new ResourceLocation("threecore", "leggings_crafting");
    public static final ResourceLocation BOOTS_CRAFTING_CATEGORY = new ResourceLocation("threecore", "boots_crafting");
    public static final ResourceLocation GRINDING_CATEGORY = new ResourceLocation("threecore", "grinding");
    public static final ResourceLocation PRESSING_CATEGORY = new ResourceLocation("threecore", "pressing");
    public static final ResourceLocation FLUID_COMPOSING_CATEGORY = new ResourceLocation("threecore", "fluid_composing");
    private HelmetCraftingCategory helmetCraftingCategory;
    private ChestplateCraftingCategory chestplateCraftingCategory;
    private LeggingsCraftingCategory leggingsCraftingCategory;
    private BootsCraftingCategory bootsCraftingCategory;
    private GrindingCategory grindingCategory;
    private PressingCategory pressingCategory;
    private FluidComposingCategory fluidComposingCategory;

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("threecore", "plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[7];
        this.helmetCraftingCategory = new HelmetCraftingCategory(guiHelper);
        iRecipeCategoryArray[0] = this.helmetCraftingCategory;
        this.chestplateCraftingCategory = new ChestplateCraftingCategory(guiHelper);
        iRecipeCategoryArray[1] = this.chestplateCraftingCategory;
        this.leggingsCraftingCategory = new LeggingsCraftingCategory(guiHelper);
        iRecipeCategoryArray[2] = this.leggingsCraftingCategory;
        this.bootsCraftingCategory = new BootsCraftingCategory(guiHelper);
        iRecipeCategoryArray[3] = this.bootsCraftingCategory;
        iRecipeCategoryArray[4] = this.grindingCategory = new GrindingCategory(guiHelper);
        iRecipeCategoryArray[5] = this.pressingCategory = new PressingCategory(guiHelper);
        iRecipeCategoryArray[6] = this.fluidComposingCategory = new FluidComposingCategory(guiHelper);
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Objects.requireNonNull(this.helmetCraftingCategory);
        Objects.requireNonNull(this.chestplateCraftingCategory);
        Objects.requireNonNull(this.leggingsCraftingCategory);
        Objects.requireNonNull(this.bootsCraftingCategory);
        Objects.requireNonNull(this.grindingCategory);
        Objects.requireNonNull(this.pressingCategory);
        Objects.requireNonNull(this.fluidComposingCategory);
        registration.addRecipes(ThreeCoreRecipeFactory.getHelmetCraftingRecipes(), HELMET_CRAFTING_CATEGORY);
        registration.addRecipes(ThreeCoreRecipeFactory.getChestplateCraftingRecipes(), CHESTPLATE_CRAFTING_CATEGORY);
        registration.addRecipes(ThreeCoreRecipeFactory.getLeggingsCraftingRecipes(), LEGGINGS_CRAFTING_CATEGORY);
        registration.addRecipes(ThreeCoreRecipeFactory.getBootsCraftingRecipes(), BOOTS_CRAFTING_CATEGORY);
        registration.addRecipes(ThreeCoreRecipeFactory.getGrinderRecipes(), GRINDING_CATEGORY);
        registration.addRecipes(ThreeCoreRecipeFactory.getPressingRecipes(), PRESSING_CATEGORY);
        registration.addRecipes(ThreeCoreRecipeFactory.getFluidComposingRecipes(), FLUID_COMPOSING_CATEGORY);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ConstructionTableScreen.Helmet.class, 94, 96, 45, 21, new ResourceLocation[]{HELMET_CRAFTING_CATEGORY});
        registration.addRecipeClickArea(ConstructionTableScreen.Chestplate.class, 94, 93, 45, 24, new ResourceLocation[]{CHESTPLATE_CRAFTING_CATEGORY});
        registration.addRecipeClickArea(ConstructionTableScreen.Leggings.class, 88, 96, 51, 21, new ResourceLocation[]{LEGGINGS_CRAFTING_CATEGORY});
        registration.addRecipeClickArea(ConstructionTableScreen.Boots.class, 94, 93, 45, 24, new ResourceLocation[]{BOOTS_CRAFTING_CATEGORY});
        registration.addRecipeClickArea(GrinderScreen.class, 66, 36, 28, 23, new ResourceLocation[]{GRINDING_CATEGORY});
        registration.addRecipeClickArea(HydraulicPressScreen.class, 96, 36, 28, 23, new ResourceLocation[]{PRESSING_CATEGORY});
        registration.addRecipeClickArea(FluidComposerScreen.class, 107, 44, 28, 23, new ResourceLocation[]{FLUID_COMPOSING_CATEGORY});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        this.addConstructionTableTransferHandler(registration, HELMET_CRAFTING_CATEGORY, HelmetCraftingContainer.class, (IRecipeSerializer)TCRecipeSerializers.HELMET_CRAFTING.get());
        this.addConstructionTableTransferHandler(registration, CHESTPLATE_CRAFTING_CATEGORY, ChestplateCraftingContainer.class, (IRecipeSerializer)TCRecipeSerializers.CHESTPLATE_CRAFTING.get());
        this.addConstructionTableTransferHandler(registration, LEGGINGS_CRAFTING_CATEGORY, LeggingsCraftingContainer.class, (IRecipeSerializer)TCRecipeSerializers.LEGGINGS_CRAFTING.get());
        this.addConstructionTableTransferHandler(registration, BOOTS_CRAFTING_CATEGORY, BootsCraftingContainer.class, (IRecipeSerializer)TCRecipeSerializers.BOOTS_CRAFTING.get());
        registration.addRecipeTransferHandler(GrinderContainer.class, GRINDING_CATEGORY, 1, 1, 4, 36);
        registration.addRecipeTransferHandler(HydraulicPressContainer.class, PRESSING_CATEGORY, 1, 2, 4, 36);
        registration.addRecipeTransferHandler(FluidComposerContainer.class, FLUID_COMPOSING_CATEGORY, 5, 9, 14, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TCBlocks.CONSTRUCTION_TABLE.get()), new ResourceLocation[]{HELMET_CRAFTING_CATEGORY, CHESTPLATE_CRAFTING_CATEGORY, LEGGINGS_CRAFTING_CATEGORY, BOOTS_CRAFTING_CATEGORY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TCBlocks.GRINDER.get()), new ResourceLocation[]{GRINDING_CATEGORY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TCBlocks.HYDRAULIC_PRESS.get()), new ResourceLocation[]{PRESSING_CATEGORY});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)TCBlocks.FLUID_COMPOSER.get()), new ResourceLocation[]{FLUID_COMPOSING_CATEGORY});
    }

    public void addConstructionTableTransferHandler(IRecipeTransferRegistration registration, ResourceLocation id, Class<? extends AbstractConstructionTableContainer> clazz, IRecipeSerializer recipeSerializer) {
        AbstractConstructionTableRecipe.Serializer serializer = (AbstractConstructionTableRecipe.Serializer)recipeSerializer;
        registration.addRecipeTransferHandler(clazz, id, 0, serializer.size + 1, serializer.size, 36);
    }
}

