/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.container.ConstructionTableInventory;
import net.threetag.threecore.item.recipe.AbstractConstructionTableRecipe;

public abstract class AbstractConstructionTableContainer<T extends AbstractConstructionTableRecipe>
extends Container {
    final ConstructionTableInventory craftingInventory;
    final CraftResultInventory craftResultInventory;
    public final IWorldPosCallable worldPosCallable;
    private final PlayerEntity player;

    protected AbstractConstructionTableContainer(@Nullable ContainerType<?> containerType, int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super(containerType, id);
        this.craftingInventory = new ConstructionTableInventory(this, this.getRecipeSerializer().size + 1);
        this.craftResultInventory = new CraftResultInventory();
        this.worldPosCallable = worldPosCallable;
        this.player = playerInventory.field_70458_d;
    }

    public abstract AbstractConstructionTableRecipe.Serializer getRecipeSerializer();

    public abstract IRecipeType<T> getRecipeType();

    public void func_75130_a(IInventory inventory) {
        this.worldPosCallable.func_221486_a((world, blockPos) -> this.updateRecipe((World)world));
    }

    protected void updateRecipe(World world) {
        if (!world.field_72995_K) {
            AbstractConstructionTableRecipe constructionTable;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)this.player;
            ItemStack stack = ItemStack.field_190927_a;
            Optional recipe = world.func_73046_m().func_199529_aN().func_215371_a(this.getRecipeType(), (IInventory)this.craftingInventory, world);
            if (recipe.isPresent() && this.craftResultInventory.func_201561_a(world, serverPlayer, (IRecipe)(constructionTable = (AbstractConstructionTableRecipe)recipe.get()))) {
                stack = constructionTable.getCraftingResult(this.craftingInventory);
            }
            this.craftResultInventory.func_70299_a(0, stack);
            serverPlayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, this.field_75151_b.size() - 36 - 1, stack));
        }
    }

    public void func_75134_a(PlayerEntity player) {
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(player, (World)world, this.craftingInventory));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return AbstractConstructionTableContainer.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)((Block)TCBlocks.CONSTRUCTION_TABLE.get()));
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResultInventory && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        int shapeSlotCount = this.craftingInventory.func_70302_i_() - 1;
        int upperSlotCount = this.craftingInventory.func_70302_i_() + 1;
        int resultSlotIndex = shapeSlotCount + 1;
        int invBegin = upperSlotCount;
        int invEnd1 = upperSlotCount + 27;
        int invEnd2 = upperSlotCount + 36;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            if (index == resultSlotIndex) {
                this.worldPosCallable.func_221486_a((world, pos) -> stack1.func_77973_b().func_77622_d(stack1, world, player));
                if (!this.func_75135_a(stack1, invBegin, invEnd2, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack1, stack);
            } else if (index >= invBegin && index < invEnd1 ? !this.func_75135_a(stack1, invEnd1, invEnd2, false) : (index >= invEnd1 && index < invEnd2 ? !this.func_75135_a(stack1, invBegin, invEnd1, false) : !this.func_75135_a(stack1, invBegin, invEnd2, false))) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack lvt_6_1_ = slot.func_190901_a(player, stack1);
            if (index == 0) {
                player.func_71019_a(lvt_6_1_, false);
            }
        }
        return stack;
    }
}

