/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.threetag.threecore.container.TCContainerTypes;
import net.threetag.threecore.tileentity.FluidComposerTileEntity;

public class FluidComposerContainer
extends Container {
    public final PlayerInventory inventoryPlayer;
    public final FluidComposerTileEntity fluidComposerTileEntity;
    private final IIntArray intArray;
    public RecipeWrapper recipeWrapper;
    protected final World world;

    public FluidComposerContainer(int id, PlayerInventory inventoryPlayer) {
        this(id, inventoryPlayer, new FluidComposerTileEntity(), (IIntArray)new IntArray(4));
    }

    public FluidComposerContainer(int id, PlayerInventory inventoryPlayer, FluidComposerTileEntity fluidComposerTileEntity) {
        this(id, inventoryPlayer, fluidComposerTileEntity, (IIntArray)new IntArray(4));
    }

    public FluidComposerContainer(int id, PlayerInventory inventoryPlayer, FluidComposerTileEntity fluidComposerTileEntity, IIntArray intArray) {
        super((ContainerType)TCContainerTypes.FLUID_COMPOSER.get(), id);
        this.inventoryPlayer = inventoryPlayer;
        this.fluidComposerTileEntity = fluidComposerTileEntity;
        this.recipeWrapper = fluidComposerTileEntity.recipeWrapper;
        this.world = inventoryPlayer.field_70458_d.field_70170_p;
        FluidComposerContainer.func_216962_a((IInventory)this.recipeWrapper, (int)9);
        FluidComposerContainer.func_216959_a((IIntArray)intArray, (int)4);
        this.intArray = intArray;
        this.func_216961_a(this.intArray);
        this.fluidComposerTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 0, 48, 95));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 1, 8, 17));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 2, 8, 103));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 3, 152, 17));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 4, 152, 103));
            int o = 5;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    this.func_75146_a((Slot)new SlotItemHandler(itemHandler, o, 46 + x * 18, 29 + y * 18));
                    ++o;
                }
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 134 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, k, 8 + k * 18, 192));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.fluidComposerTileEntity.func_70300_a(playerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int width) {
        int progress = this.intArray.func_221476_a(0);
        int maxProgress = this.intArray.func_221476_a(1);
        return maxProgress != 0 && progress != 0 ? progress * width / maxProgress : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEnergyPercentage() {
        return (float)this.intArray.func_221476_a(2) / (float)this.intArray.func_221476_a(3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyStored() {
        return this.intArray.func_221476_a(2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxEnergyStored() {
        return this.intArray.func_221476_a(3);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            if (index >= 14) {
                if (stack1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                    if (FluidUtil.tryEmptyContainer((ItemStack)stack1, (IFluidHandler)this.fluidComposerTileEntity.inputFluidTank, (int)Integer.MAX_VALUE, null, (boolean)false).isSuccess() && !this.func_75135_a(stack1, 1, 2, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (FluidUtil.tryEmptyContainer((ItemStack)stack1, (IFluidHandler)this.fluidComposerTileEntity.outputFluidTank, (int)Integer.MAX_VALUE, null, (boolean)false).isSuccess() && !this.func_75135_a(stack1, 3, 4, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (FluidUtil.tryFillContainer((ItemStack)stack1, (IFluidHandler)this.fluidComposerTileEntity.inputFluidTank, (int)Integer.MAX_VALUE, null, (boolean)false).isSuccess() && !this.func_75135_a(stack1, 2, 3, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (FluidUtil.tryFillContainer((ItemStack)stack1, (IFluidHandler)this.fluidComposerTileEntity.outputFluidTank, (int)Integer.MAX_VALUE, null, (boolean)false).isSuccess() && !this.func_75135_a(stack1, 4, 5, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (stack1.getCapability(CapabilityEnergy.ENERGY).isPresent() ? !this.func_75135_a(stack1, 0, 1, false) : (!this.isFull((IInventory)this.recipeWrapper) ? !this.func_75135_a(stack1, 5, 14, false) : (index >= 14 && index < 41 ? !this.func_75135_a(stack1, 41, 50, false) : index >= 41 && index < 50 && !this.func_75135_a(stack1, 14, 41, false)))) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stack1, 14, 50, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack1);
        }
        return stack;
    }

    public boolean isFull(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

