/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.threetag.threecore.client.renderer.entity.ProjectileEntityRenderer;
import net.threetag.threecore.client.renderer.entity.SolidItemEntityRenderer;
import net.threetag.threecore.client.renderer.entity.SuitStandRenderer;
import net.threetag.threecore.entity.ProjectileEntity;
import net.threetag.threecore.entity.SolidItemEntity;
import net.threetag.threecore.entity.SuitStandEntity;
import net.threetag.threecore.entity.attributes.TCAttributes;
import net.threetag.threecore.util.entityeffect.EffectEntity;
import net.threetag.threecore.util.entityeffect.EffectEntityRenderer;

public class TCEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"threecore");
    public static final RegistryObject<EntityType<SuitStandEntity>> SUIT_STAND = TCEntityTypes.register("suit_stand", () -> EntityType.Builder.func_220322_a(SuitStandEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.75f, 2.0f));
    public static final RegistryObject<EntityType<ProjectileEntity>> PROJECTILE = TCEntityTypes.register("projectile", () -> EntityType.Builder.func_220322_a(ProjectileEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final RegistryObject<EntityType<SolidItemEntity>> SOLID_ITEM_ENTITY = TCEntityTypes.register("solid_item", () -> EntityType.Builder.func_220322_a(SolidItemEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f));
    public static final RegistryObject<EntityType<EffectEntity>> EFFECT = TCEntityTypes.register("effect", () -> EntityType.Builder.func_220322_a(EffectEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.1f, 0.1f));

    public static void initAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)SUIT_STAND.get()), (AttributeModifierMap)LivingEntity.func_233639_cI_().func_233813_a_());
        for (EntityType value : ForgeRegistries.ENTITIES.getValues()) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_((EntityType)value);
            if (map == null) continue;
            Map oldAttributes = map.field_233802_a_;
            AttributeModifierMap.MutableAttribute newMap = AttributeModifierMap.func_233803_a_();
            newMap.field_233811_a_.putAll(oldAttributes);
            newMap.func_233815_a_((Attribute)TCAttributes.STEP_HEIGHT.get(), 1.0);
            newMap.func_233814_a_((Attribute)TCAttributes.FALL_RESISTANCE.get());
            newMap.func_233814_a_((Attribute)TCAttributes.JUMP_HEIGHT.get());
            newMap.func_233815_a_((Attribute)TCAttributes.SPRINT_SPEED.get(), 1.0);
            newMap.func_233814_a_((Attribute)TCAttributes.SIZE_WIDTH.get());
            newMap.func_233814_a_((Attribute)TCAttributes.SIZE_HEIGHT.get());
            GlobalEntityTypeAttributes.put((EntityType)value, (AttributeModifierMap)newMap.func_233813_a_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initRenderers() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SUIT_STAND.get()), SuitStandRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PROJECTILE.get()), manager -> new ProjectileEntityRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SOLID_ITEM_ENTITY.get()), SolidItemEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EFFECT.get()), EffectEntityRenderer::new);
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> register(String id, Supplier<EntityType.Builder<T>> builderSupplier) {
        return ENTITIES.register(id, () -> ((EntityType.Builder)builderSupplier.get()).func_206830_a("threecore:" + id));
    }
}

