/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.addonpacks.item.ItemParser;
import net.threetag.threecore.capability.ItemAbilityContainerProvider;

public class AbilityItem
extends Item
implements IAbilityProvider {
    private List<Supplier<Ability>> abilityGenerators;
    private List<ITextComponent> description;

    public AbilityItem(Item.Properties properties) {
        super(properties);
    }

    public AbilityItem(JsonObject json, Item.Properties properties) {
        super(properties);
        this.setAbilities(JSONUtils.func_151204_g((JsonObject)json, (String)"abilities") ? AbilityHelper.parseAbilityGenerators(JSONUtils.func_152754_s((JsonObject)json, (String)"abilities"), true) : null);
        this.setDescription(JSONUtils.func_151204_g((JsonObject)json, (String)"description") ? ItemParser.parseDescriptionLines(json.get("description")) : null);
    }

    public AbilityItem setAbilities(List<Supplier<Ability>> abilities) {
        this.abilityGenerators = abilities;
        return this;
    }

    public AbilityItem addAbility(Supplier<Ability> abilityGenerator) {
        if (this.abilityGenerators == null) {
            this.abilityGenerators = Lists.newArrayList();
        }
        this.abilityGenerators.add(abilityGenerator);
        return this;
    }

    public AbilityItem setDescription(List<ITextComponent> description) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.description = description;
        });
        return this;
    }

    public AbilityItem addDescriptionLine(ITextComponent line) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.description == null) {
                this.description = Lists.newArrayList();
            }
            this.description.add(line);
        });
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.description != null) {
            tooltip.addAll(this.description);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemAbilityContainerProvider(stack);
    }

    @Override
    public AbilityMap getAbilities() {
        return new AbilityMap(this.abilityGenerators);
    }
}

