/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;

public class ArmorMaterialRegistry {
    private static Map<String, IArmorMaterial> ARMOR_MATERIALS = new HashMap<String, IArmorMaterial>();

    public static IArmorMaterial getArmorMaterial(String name) {
        return ARMOR_MATERIALS.get(name.toLowerCase());
    }

    public static IArmorMaterial addArmorMaterial(String name, IArmorMaterial armorMaterial) {
        ARMOR_MATERIALS.put(name.toLowerCase(), armorMaterial);
        return armorMaterial;
    }

    public static IArmorMaterial getOrCreateArmorMaterial(String name, Supplier<IArmorMaterial> armorMaterialSupplier) {
        return ArmorMaterialRegistry.getArmorMaterial(name) != null ? ArmorMaterialRegistry.getArmorMaterial(name) : ArmorMaterialRegistry.addArmorMaterial(name, armorMaterialSupplier.get());
    }

    static {
        ArmorMaterialRegistry.addArmorMaterial("leather", (IArmorMaterial)ArmorMaterial.LEATHER);
        ArmorMaterialRegistry.addArmorMaterial("chain", (IArmorMaterial)ArmorMaterial.CHAIN);
        ArmorMaterialRegistry.addArmorMaterial("iron", (IArmorMaterial)ArmorMaterial.IRON);
        ArmorMaterialRegistry.addArmorMaterial("gold", (IArmorMaterial)ArmorMaterial.GOLD);
        ArmorMaterialRegistry.addArmorMaterial("diamond", (IArmorMaterial)ArmorMaterial.DIAMOND);
        ArmorMaterialRegistry.addArmorMaterial("turtle", (IArmorMaterial)ArmorMaterial.TURTLE);
    }
}

