/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.item.recipe.MultiverseManager;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;
import net.threetag.threecore.util.RecipeUtil;

public class MultiversalRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<MultiversalRecipe> RECIPE_TYPE = RecipeUtil.register("multiversal");
    private final ResourceLocation id;
    private final String universe;
    private final String identifier;
    private final List<Item> items;

    public MultiversalRecipe(ResourceLocation id, String universe, String identifier, List<Item> items) {
        this.id = id;
        this.universe = universe;
        this.identifier = identifier;
        this.items = items;
    }

    public String getUniverse() {
        return this.universe;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<MultiversalRecipe> func_199559_b() {
        return (IRecipeSerializer)TCRecipeSerializers.MULTIVERSAL.get();
    }

    public IRecipeType<MultiversalRecipe> func_222127_g() {
        return RECIPE_TYPE;
    }

    public static List<String> getIdentifiersFromItem(ItemStack stack, World world) {
        ArrayList list = Lists.newArrayList();
        world.func_199532_z().func_215366_a(RECIPE_TYPE).forEach((id, recipe) -> {
            if (recipe instanceof MultiversalRecipe) {
                for (Item item : ((MultiversalRecipe)recipe).getItems()) {
                    if (stack.func_77973_b() != item || list.contains(((MultiversalRecipe)recipe).getIdentifier())) continue;
                    list.add(((MultiversalRecipe)recipe).getIdentifier());
                }
            }
        });
        return list;
    }

    public static List<String> getUniversesFromItem(ItemStack stack, World world) {
        ArrayList list = Lists.newArrayList();
        world.func_199532_z().func_215366_a(RECIPE_TYPE).forEach((id, recipe) -> {
            if (recipe instanceof MultiversalRecipe) {
                for (Item item : ((MultiversalRecipe)recipe).getItems()) {
                    if (stack.func_77973_b() != item || list.contains(((MultiversalRecipe)recipe).getUniverse())) continue;
                    list.add(((MultiversalRecipe)recipe).getUniverse());
                }
            }
        });
        return list;
    }

    public static List<ItemStack> getVariations(ItemStack stack, String universe, List<String> identifiers, World world) {
        ArrayList items = Lists.newArrayList();
        world.func_199532_z().func_215366_a(RECIPE_TYPE).forEach((id, recipe) -> {
            if (recipe instanceof MultiversalRecipe && ((MultiversalRecipe)recipe).getUniverse().equals(universe) && identifiers.contains(((MultiversalRecipe)recipe).getIdentifier()) && ((MultiversalRecipe)recipe).getUniverse().equals(universe)) {
                for (Item item : ((MultiversalRecipe)recipe).getItems()) {
                    if (stack.func_77973_b() == item) continue;
                    ItemStack result = new ItemStack((IItemProvider)item);
                    result.func_77982_d(stack.func_77978_p());
                    items.add(result);
                }
            }
        });
        return items;
    }

    public static boolean hasVariations(ItemStack stack, World world) {
        for (Map.Entry entry : world.func_199532_z().func_215366_a(RECIPE_TYPE).entrySet()) {
            if (!(entry.getValue() instanceof MultiversalRecipe)) continue;
            for (Item item : ((MultiversalRecipe)entry.getValue()).getItems()) {
                if (stack.func_77973_b() != item) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MultiversalRecipe> {
        public MultiversalRecipe read(ResourceLocation recipeId, JsonObject json) {
            MultiverseManager.Universe universe = MultiverseManager.registerUniverse(JSONUtils.func_151200_h((JsonObject)json, (String)"universe"));
            String identifier = JSONUtils.func_151200_h((JsonObject)json, (String)"identifier");
            ArrayList items = Lists.newArrayList();
            JsonElement itemsJson = json.get("items");
            if (itemsJson.isJsonPrimitive()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemsJson.getAsString()));
                if (item == null) {
                    throw new JsonParseException("Item " + itemsJson.getAsString() + " in recipe " + recipeId + " does not exist!");
                }
                items.add(item);
            } else if (itemsJson.isJsonArray()) {
                for (int i = 0; i < itemsJson.getAsJsonArray().size(); ++i) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemsJson.getAsJsonArray().get(i).getAsString()));
                    if (item == null) {
                        throw new JsonParseException("Item " + itemsJson.getAsString() + " in recipe " + recipeId + " does not exist!");
                    }
                    items.add(item);
                }
            }
            return new MultiversalRecipe(recipeId, universe.getIdentifier(), identifier, items);
        }

        @Nullable
        public MultiversalRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            MultiverseManager.Universe universe = MultiverseManager.registerUniverse(buffer.func_218666_n());
            String identifier = buffer.func_218666_n();
            ArrayList items = Lists.newArrayList();
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                Item item = (Item)buffer.readRegistryId();
                items.add(item);
            }
            return new MultiversalRecipe(recipeId, universe.getIdentifier(), identifier, items);
        }

        public void write(PacketBuffer buffer, MultiversalRecipe recipe) {
            buffer.func_180714_a(recipe.universe);
            buffer.func_180714_a(recipe.identifier);
            buffer.writeInt(recipe.items.size());
            for (Item item : recipe.items) {
                buffer.writeRegistryId((IForgeRegistryEntry)item);
            }
        }
    }
}

