/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.IAbilityContainer;

public class AbilityKeyMessage {
    public ResourceLocation containerId;
    public String abilityId;
    public boolean pressed;

    public AbilityKeyMessage(ResourceLocation containerId, String abilityId, boolean pressed) {
        this.containerId = containerId;
        this.abilityId = abilityId;
        this.pressed = pressed;
    }

    public AbilityKeyMessage(PacketBuffer buffer) {
        this.containerId = new ResourceLocation(buffer.func_150789_c(64));
        this.abilityId = buffer.func_150789_c(32);
        this.pressed = buffer.readBoolean();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_180714_a(this.containerId.toString());
        buffer.func_180714_a(this.abilityId);
        buffer.writeBoolean(this.pressed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Ability ability;
            IAbilityContainer container = AbilityHelper.getAbilityContainerFromId((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.containerId);
            if (container != null && (ability = container.getAbility(this.abilityId)) != null && ability.getConditionManager().isUnlocked()) {
                if (this.pressed) {
                    ability.getConditionManager().onKeyPressed();
                } else {
                    ability.getConditionManager().onKeyReleased();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

