/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.ability.condition.BuyableAbilityCondition;
import net.threetag.threecore.ability.condition.Condition;

public class BuyConditionMessage {
    public ResourceLocation containerId;
    public String abilityId;
    public UUID conditionId;

    public BuyConditionMessage(ResourceLocation containerId, String abilityId, UUID conditionId) {
        this.containerId = containerId;
        this.abilityId = abilityId;
        this.conditionId = conditionId;
    }

    public BuyConditionMessage(PacketBuffer buffer) {
        this.containerId = new ResourceLocation(buffer.func_150789_c(64));
        this.abilityId = buffer.func_150789_c(32);
        this.conditionId = buffer.func_179253_g();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.func_180714_a(this.containerId.toString());
        buffer.func_180714_a(this.abilityId);
        buffer.func_179252_a(this.conditionId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Condition condition;
            Ability ability;
            IAbilityContainer container;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (container = AbilityHelper.getAbilityContainerFromId((LivingEntity)player, this.containerId)) != null && (ability = (Ability)container.getAbilityMap().get(this.abilityId)) != null && (condition = ability.getConditionManager().getByUniqueId(this.conditionId)) instanceof BuyableAbilityCondition && ((BuyableAbilityCondition)condition).isAvailable((LivingEntity)player)) {
                ((BuyableAbilityCondition)condition).buy((LivingEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

