/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.CapabilityThreeData;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.CompoundNBTAccessor;
import net.threetag.threecore.scripts.accessors.LivingEntityAccessor;
import net.threetag.threecore.scripts.accessors.ScriptAccessor;
import net.threetag.threecore.scripts.accessors.Vector3dAccessor;
import net.threetag.threecore.scripts.accessors.WorldAccessor;
import net.threetag.threecore.sizechanging.SizeChangeType;
import net.threetag.threecore.util.EntityUtil;
import net.threetag.threecore.util.PlayerUtil;
import net.threetag.threecore.util.threedata.FloatThreeData;
import net.threetag.threecore.util.threedata.IThreeDataHolder;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class EntityAccessor
extends ScriptAccessor<Entity> {
    public final WorldAccessor world;

    public EntityAccessor(Entity value) {
        super(value);
        this.world = (WorldAccessor)EntityAccessor.makeAccessor(value.field_70170_p);
    }

    public String getName() {
        return ((Entity)this.value).func_145748_c_().getString();
    }

    public void setName(@ScriptParameterName(value="name") String name) {
        ((Entity)this.value).func_200203_b((ITextComponent)new StringTextComponent(name));
    }

    public void setNameVisible(@ScriptParameterName(value="visible") boolean visible) {
        ((Entity)this.value).func_174805_g(visible);
    }

    public WorldAccessor getWorld() {
        return this.world;
    }

    public String getUUID() {
        return ((Entity)this.value).func_110124_au().toString();
    }

    public CompoundNBTAccessor getNBTData() {
        return new CompoundNBTAccessor(((Entity)this.value).serializeNBT());
    }

    public Vector3dAccessor getPosition() {
        return new Vector3dAccessor(((Entity)this.value).func_213303_ch());
    }

    public double getPosX() {
        return ((Entity)this.value).func_226277_ct_();
    }

    public double getPosY() {
        return ((Entity)this.value).func_226278_cu_();
    }

    public double getPosZ() {
        return ((Entity)this.value).func_226281_cx_();
    }

    public float getYaw() {
        return ((Entity)this.value).field_70177_z;
    }

    public float setYaw(@ScriptParameterName(value="yaw") float yaw) {
        ((Entity)this.value).field_70177_z = yaw;
        return ((Entity)this.value).field_70177_z;
    }

    public float getPitch() {
        return ((Entity)this.value).field_70125_A;
    }

    public void setPitch(@ScriptParameterName(value="pitch") float pitch) {
        ((Entity)this.value).field_70125_A = pitch;
    }

    public void setPosition(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z) {
        ((Entity)this.value).func_70634_a(x, y, z);
    }

    public void setRotation(@ScriptParameterName(value="yaw") float yaw, @ScriptParameterName(value="pitch") float pitch) {
        this.setPositionAndRotation(this.getPosX(), this.getPosY(), this.getPosZ(), yaw, pitch);
    }

    public void setPositionAndRotation(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z, @ScriptParameterName(value="yaw") float yaw, @ScriptParameterName(value="pitch") float pitch) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        ((Entity)this.value).func_70634_a(x, y, z);
    }

    public Vector3dAccessor getLookVec() {
        return new Vector3dAccessor(((Entity)this.value).func_70040_Z());
    }

    public Vector3dAccessor getMotion() {
        return new Vector3dAccessor(((Entity)this.value).func_213322_ci());
    }

    public void setMotion(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z) {
        ((Entity)this.value).func_213293_j(x, y, z);
    }

    public void addMotion(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z) {
        this.setMotion(((Entity)this.value).func_213322_ci().field_72450_a + x, ((Entity)this.value).func_213322_ci().field_72448_b + y, ((Entity)this.value).func_213322_ci().field_72449_c + z);
    }

    public void setPlayerMotion(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z) {
        if (!((World)this.world.value).field_72995_K && this.value instanceof ServerPlayerEntity) {
            ((Entity)this.value).func_213293_j(x, y, z);
            ((ServerPlayerEntity)this.value).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)this.value));
        }
    }

    public Direction getHorizontalFacing() {
        return ((Entity)this.value).func_174811_aO();
    }

    public float getWidth() {
        return ((Entity)this.value).func_213311_cf();
    }

    public float getHeight() {
        return ((Entity)this.value).func_213302_cg();
    }

    public float getEyeHeight() {
        return ((Entity)this.value).func_70047_e();
    }

    public int getTicksExisted() {
        return ((Entity)this.value).field_70173_aa;
    }

    public void sendMessage(@ScriptParameterName(value="message") String message) {
        ((Entity)this.value).func_145747_a((ITextComponent)new StringTextComponent(message), ((Entity)this.value).func_110124_au());
    }

    public void sendTranslatedMessage(@ScriptParameterName(value="translationKey") String message, Object ... args) {
        ((Entity)this.value).func_145747_a((ITextComponent)new TranslationTextComponent(message, args), ((Entity)this.value).func_110124_au());
    }

    public boolean isCrouching() {
        return ((Entity)this.value).func_213453_ef();
    }

    public boolean isAlive() {
        return ((Entity)this.value).func_70089_S();
    }

    public boolean isPlayer() {
        return this.value instanceof PlayerEntity;
    }

    public boolean isLiving() {
        return this.value instanceof LivingEntity;
    }

    public LivingEntityAccessor getAsLiving() {
        return new LivingEntityAccessor((LivingEntity)this.value);
    }

    public String getType() {
        return ((Entity)this.value).func_200600_R().getRegistryName().toString();
    }

    public void kill() {
        ((Entity)this.value).func_174812_G();
    }

    public boolean isInvisible() {
        return ((Entity)this.value).func_82150_aj();
    }

    public void setInvisible(@ScriptParameterName(value="invisible") boolean invisible) {
        ((Entity)this.value).func_82142_c(invisible);
    }

    public boolean isOnGround() {
        return ((Entity)this.value).func_233570_aj_();
    }

    public float getFallDistance() {
        return ((Entity)this.value).field_70143_R;
    }

    public void setFallDistance(@ScriptParameterName(value="fallDistance") float fallDistance) {
        ((Entity)this.value).field_70143_R = fallDistance;
    }

    public boolean noClip() {
        return ((Entity)this.value).field_70145_X;
    }

    public void setNoClip(@ScriptParameterName(value="noClip") boolean noClip) {
        ((Entity)this.value).field_70145_X = noClip;
    }

    public boolean hasNoGravity() {
        return ((Entity)this.value).func_189652_ae();
    }

    public void setNoGravity(@ScriptParameterName(value="noGravity") boolean noGravity) {
        ((Entity)this.value).func_189654_d(noGravity);
    }

    public int executeCommand(@ScriptParameterName(value="command") String command) {
        if (((Entity)this.value).field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)((Entity)this.value).field_70170_p).func_73046_m().func_195571_aL().func_197059_a(((Entity)this.value).func_195051_bN(), command);
        }
        return 0;
    }

    public boolean startRiding(@ScriptParameterName(value="entity") EntityAccessor entity, @ScriptParameterName(value="force") boolean force) {
        return ((Entity)this.value).func_184205_a((Entity)entity.value, force);
    }

    public void removePassengers() {
        ((Entity)this.value).func_184226_ay();
    }

    public void stopRiding() {
        ((Entity)this.value).func_184210_p();
    }

    public EntityAccessor[] getPassengers() {
        EntityAccessor[] passengers = new EntityAccessor[((Entity)this.value).func_184188_bt().size()];
        for (int i = 0; i < passengers.length; ++i) {
            passengers[i] = new EntityAccessor((Entity)((Entity)this.value).func_184188_bt().get(i));
        }
        return passengers;
    }

    public boolean isPassenger(@ScriptParameterName(value="entity") EntityAccessor entity) {
        return ((Entity)this.value).func_184196_w((Entity)entity.value);
    }

    public void setOnFire(@ScriptParameterName(value="seconds") int seconds) {
        ((Entity)this.value).func_70015_d(seconds);
    }

    public boolean isImmuneToFire() {
        return ((Entity)this.value).func_230279_az_();
    }

    public void extinguish() {
        ((Entity)this.value).func_70066_B();
    }

    public CompoundNBTAccessor getPersistentData() {
        return new CompoundNBTAccessor(((Entity)this.value).getPersistentData());
    }

    public void playSoundAt(@ScriptParameterName(value="id") String id, @ScriptParameterName(value="volume") float volume, @ScriptParameterName(value="pitch") float pitch) {
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(id));
        if (soundEvent != null) {
            PlayerUtil.playSoundToAll(((Entity)this.value).field_70170_p, this.getPosX(), this.getPosY() + (double)this.getHeight() / 2.0, this.getPosZ(), 50.0, soundEvent, ((Entity)this.value).func_184176_by(), volume, pitch);
        }
    }

    public void startSizeChange(@ScriptParameterName(value="size") float size, @ScriptParameterName(value="sizeChangeType") String sizeChangeType) {
        ((Entity)this.value).getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            SizeChangeType type = (SizeChangeType)SizeChangeType.REGISTRY.getValue(new ResourceLocation(sizeChangeType));
            sizeChanging.startSizeChange(type, size);
        });
    }

    public void setSizeDirectly(@ScriptParameterName(value="size") float size, @ScriptParameterName(value="sizeChangeType") String sizeChangeType) {
        ((Entity)this.value).getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            SizeChangeType type = (SizeChangeType)SizeChangeType.REGISTRY.getValue(new ResourceLocation(sizeChangeType));
            sizeChanging.setSizeDirectly(type, size);
        });
    }

    public Object getThreeData(@ScriptParameterName(value="key") String key) {
        IThreeDataHolder threeData = (IThreeDataHolder)((Entity)this.value).getCapability(CapabilityThreeData.THREE_DATA).orElse(null);
        if (threeData == null) {
            return null;
        }
        ThreeData<?> data = threeData.getDataByName(key);
        return data == null ? null : threeData.get(data);
    }

    public boolean setThreeData(@ScriptParameterName(value="key") String key, @ScriptParameterName(value="value") Object value) {
        IThreeDataHolder threeData = (IThreeDataHolder)((Entity)this.value).getCapability(CapabilityThreeData.THREE_DATA).orElse(null);
        if (threeData == null) {
            return false;
        }
        ThreeData<?> data = threeData.getDataByName(key);
        if (data == null) {
            return false;
        }
        if (data instanceof IntegerThreeData) {
            if (value instanceof Double) {
                value = ((Double)value).intValue();
            } else if (value instanceof Float) {
                value = ((Float)value).intValue();
            }
        }
        if (data instanceof FloatThreeData) {
            if (value instanceof Double) {
                value = Float.valueOf(((Double)value).floatValue());
            } else if (value instanceof Integer) {
                value = Float.valueOf(((Integer)value).floatValue());
            }
        }
        threeData.set(data, value);
        return true;
    }

    public Object rayTrace(@ScriptParameterName(value="distance") double distance, @ScriptParameterName(value="blockMode") String blockMode, @ScriptParameterName(value="fluidMode") String fluidMode) {
        RayTraceContext.BlockMode b = RayTraceContext.BlockMode.valueOf((String)blockMode.toUpperCase());
        RayTraceContext.FluidMode f = RayTraceContext.FluidMode.valueOf((String)fluidMode.toUpperCase());
        return ScriptAccessor.makeAccessor(EntityUtil.rayTraceWithEntities((Entity)this.value, distance, b, f));
    }

    public void lookAt(@ScriptParameterName(value="target") Vector3dAccessor target) {
        ((Entity)this.value).func_200602_a(EntityAnchorArgument.Type.EYES, (Vector3d)target.value);
    }
}

