/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.ability.superpower.Superpower;
import net.threetag.threecore.ability.superpower.SuperpowerManager;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.AbilityAccessor;
import net.threetag.threecore.scripts.accessors.EntityAccessor;
import net.threetag.threecore.scripts.accessors.ItemStackAccessor;

public class LivingEntityAccessor
extends EntityAccessor {
    public final LivingEntity livingEntity;

    protected LivingEntityAccessor(LivingEntity entity) {
        super((Entity)entity);
        this.livingEntity = entity;
    }

    public boolean isChild() {
        return this.livingEntity.func_70631_g_();
    }

    public float getHealth() {
        return this.livingEntity.func_110143_aJ();
    }

    public void setHealth(@ScriptParameterName(value="health") float health) {
        this.livingEntity.func_70606_j(health);
    }

    public float getMaxHealth() {
        return this.livingEntity.func_110138_aP();
    }

    public void heal(@ScriptParameterName(value="amount") float amount) {
        this.livingEntity.func_70691_i(amount);
    }

    public boolean isUndead() {
        return this.livingEntity.func_70662_br();
    }

    public boolean isOnLadder() {
        return this.livingEntity.func_70617_f_();
    }

    public boolean isSleeping() {
        return this.livingEntity.func_70608_bn();
    }

    public boolean isElytraFlying() {
        return this.livingEntity.func_184613_cA();
    }

    public float getAbsorptionAmount() {
        return this.livingEntity.func_110139_bj();
    }

    public float getMovementSpeed() {
        return this.livingEntity.func_70689_ay();
    }

    public void setMovementSpeed(@ScriptParameterName(value="speed") float speed) {
        this.livingEntity.func_70659_e(speed);
    }

    public boolean isSprinting() {
        return this.livingEntity.func_70051_ag();
    }

    public void swingArm(@ScriptParameterName(value="mainHand") boolean mainHand) {
        this.livingEntity.func_226292_a_(mainHand ? Hand.MAIN_HAND : Hand.OFF_HAND, true);
    }

    public ItemStackAccessor getItemInSlot(@ScriptParameterName(value="slot") String slot) {
        try {
            EquipmentSlotType slotType = EquipmentSlotType.func_188451_a((String)slot);
            return new ItemStackAccessor(this.livingEntity.func_184582_a(slotType));
        }
        catch (Exception e) {
            return ItemStackAccessor.EMPTY;
        }
    }

    public void setItemInSlot(@ScriptParameterName(value="slot") String slot, @ScriptParameterName(value="item") Object item) {
        try {
            EquipmentSlotType slotType = EquipmentSlotType.func_188451_a((String)slot);
            ItemStackAccessor stack = item instanceof ItemStackAccessor ? (ItemStackAccessor)item : new ItemStackAccessor(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.toString()))));
            this.livingEntity.func_184201_a(slotType, (ItemStack)stack.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AbilityAccessor[] getAbilities() {
        List<Ability> list = AbilityHelper.getAbilities(this.livingEntity);
        AbilityAccessor[] array = new AbilityAccessor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = new AbilityAccessor(list.get(i));
        }
        return array;
    }

    public AbilityAccessor[] getAbilities(@ScriptParameterName(value="containerId") String containerId) {
        IAbilityContainer container = AbilityHelper.getAbilityContainerFromId(this.livingEntity, new ResourceLocation(containerId));
        if (container != null) {
            return new AbilityAccessor[0];
        }
        Collection list = container.getAbilities().stream().map(a -> new AbilityAccessor((Ability)a)).collect(Collectors.toList());
        AbilityAccessor[] array = new AbilityAccessor[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbilityAccessor abilityAccessor;
            array[i] = abilityAccessor = (AbilityAccessor)iterator.next();
            ++i;
        }
        return array;
    }

    public AbilityAccessor getAbilityById(@ScriptParameterName(value="abilityId") String id) {
        return (AbilityAccessor)AbilityAccessor.makeAccessor(AbilityHelper.getAbilityById(this.livingEntity, id, null));
    }

    public void attackEntityFrom(@ScriptParameterName(value="sourceName") String source, @ScriptParameterName(value="amount") float amount) {
        DamageSource damageSource = null;
        switch (source) {
            case "inFire": {
                damageSource = DamageSource.field_76372_a;
                break;
            }
            case "lightningBolt": {
                damageSource = DamageSource.field_180137_b;
                break;
            }
            case "onFire": {
                damageSource = DamageSource.field_76370_b;
                break;
            }
            case "lava": {
                damageSource = DamageSource.field_76371_c;
                break;
            }
            case "hotFloor": {
                damageSource = DamageSource.field_190095_e;
                break;
            }
            case "inWall": {
                damageSource = DamageSource.field_76368_d;
                break;
            }
            case "cramming": {
                damageSource = DamageSource.field_191291_g;
                break;
            }
            case "drown": {
                damageSource = DamageSource.field_76369_e;
                break;
            }
            case "starve": {
                damageSource = DamageSource.field_76366_f;
                break;
            }
            case "cactus": {
                damageSource = DamageSource.field_76367_g;
                break;
            }
            case "fall": {
                damageSource = DamageSource.field_76379_h;
                break;
            }
            case "flyIntoWall": {
                damageSource = DamageSource.field_188406_j;
                break;
            }
            case "outOfWorld": {
                damageSource = DamageSource.field_76380_i;
                break;
            }
            case "generic": {
                damageSource = DamageSource.field_76377_j;
                break;
            }
            case "magic": {
                damageSource = DamageSource.field_76376_m;
                break;
            }
            case "wither": {
                damageSource = DamageSource.field_82727_n;
                break;
            }
            case "anvil": {
                damageSource = DamageSource.field_82728_o;
                break;
            }
            case "fallingBlock": {
                damageSource = DamageSource.field_82729_p;
                break;
            }
            case "dragonBreath": {
                damageSource = DamageSource.field_188407_q;
                break;
            }
            case "dryout": {
                damageSource = DamageSource.field_205132_u;
                break;
            }
            case "sweetBerryBush": {
                damageSource = DamageSource.field_220302_v;
            }
        }
        if (damageSource != null) {
            this.livingEntity.func_70097_a(damageSource, amount);
        }
    }

    public void attackEntityFromMob(@ScriptParameterName(value="attacker") LivingEntityAccessor entity, @ScriptParameterName(value="amount") float amount) {
        this.livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)entity.livingEntity), amount);
    }

    public void attackEntityFromPlayer(@ScriptParameterName(value="playerAttacker") LivingEntityAccessor entity, @ScriptParameterName(value="amount") float amount) {
        if (entity.livingEntity instanceof PlayerEntity) {
            this.livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entity.livingEntity)), amount);
        }
    }

    public void attackEntityFromThrowable(@ScriptParameterName(value="throwable") EntityAccessor entity, @ScriptParameterName(value="@Nullable thrower") EntityAccessor thrower, @ScriptParameterName(value="float") float amount) {
        this.livingEntity.func_70097_a(DamageSource.func_76356_a((Entity)((Entity)entity.value), thrower == null ? null : (Entity)thrower.value), amount);
    }

    public void attackEntityFromExplosion(@ScriptParameterName(value="@Nullable attacker") LivingEntityAccessor attacker, @ScriptParameterName(value="float") float amount) {
        this.livingEntity.func_70097_a(DamageSource.func_188405_b((LivingEntity)(attacker == null ? null : attacker.livingEntity)), amount);
    }

    public void addSuperpower(@ScriptParameterName(value="superpower") String superpower) {
        Superpower s = SuperpowerManager.getInstance().getSuperpower(new ResourceLocation(superpower));
        if (s != null) {
            SuperpowerManager.addSuperpower(this.livingEntity, s);
        }
    }
}

