/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.AbilityAccessor;
import net.threetag.threecore.scripts.accessors.BlockRayTraceResultAccessor;
import net.threetag.threecore.scripts.accessors.BlockStateAccessor;
import net.threetag.threecore.scripts.accessors.CompoundNBTAccessor;
import net.threetag.threecore.scripts.accessors.ConditionAccessor;
import net.threetag.threecore.scripts.accessors.DamageSourceAccessor;
import net.threetag.threecore.scripts.accessors.EntityAccessor;
import net.threetag.threecore.scripts.accessors.EntityRayTraceResultAccessor;
import net.threetag.threecore.scripts.accessors.ItemStackAccessor;
import net.threetag.threecore.scripts.accessors.LivingEntityAccessor;
import net.threetag.threecore.scripts.accessors.MaterialAccessor;
import net.threetag.threecore.scripts.accessors.Vector3dAccessor;
import net.threetag.threecore.scripts.accessors.WorldAccessor;

public class ScriptAccessor<T> {
    public final T value;

    protected ScriptAccessor(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static <T> ScriptAccessor<T> makeAccessor(T object) {
        if (object instanceof LivingEntity) {
            return new LivingEntityAccessor((LivingEntity)object);
        }
        if (object instanceof Entity) {
            return new EntityAccessor((Entity)object);
        }
        if (object instanceof World) {
            return new WorldAccessor((World)object);
        }
        if (object instanceof BlockState) {
            return new BlockStateAccessor((BlockState)object);
        }
        if (object instanceof DamageSource) {
            return new DamageSourceAccessor((DamageSource)object);
        }
        if (object instanceof Ability) {
            return new AbilityAccessor((Ability)object);
        }
        if (object instanceof Condition) {
            return new ConditionAccessor((Condition)object);
        }
        if (object instanceof Vector3d) {
            return new Vector3dAccessor((Vector3d)object);
        }
        if (object instanceof Material) {
            return new MaterialAccessor((Material)object);
        }
        if (object instanceof EntityRayTraceResult) {
            return new EntityRayTraceResultAccessor((EntityRayTraceResult)object);
        }
        if (object instanceof BlockRayTraceResult) {
            return new BlockRayTraceResultAccessor((BlockRayTraceResult)object);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateHtmlFile(File file) {
        List<String> ignoredMethods = Arrays.asList("fire", "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll");
        List<Class> accessorClasses = Arrays.asList(EntityAccessor.class, LivingEntityAccessor.class, WorldAccessor.class, BlockStateAccessor.class, DamageSourceAccessor.class, AbilityAccessor.class, ConditionAccessor.class, CompoundNBTAccessor.class, Vector3dAccessor.class, MaterialAccessor.class, ItemStackAccessor.class, BlockRayTraceResultAccessor.class, EntityRayTraceResultAccessor.class);
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            LinkedList lines = Lists.newLinkedList();
            lines.add("<html><head><title>Script Accessors</title><style>\ntable{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}\n</style><link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"https://i.imgur.com/am80ox1.png\"></head><body>");
            lines.add("<ul>");
            for (Class clazz : accessorClasses) {
                lines.add("<li><a href=\"#" + clazz.getSimpleName() + "\">" + clazz.getSimpleName() + "</a></li>");
            }
            lines.add("</ul>");
            lines.add("<hr>\n");
            for (Class clazz : accessorClasses) {
                String name = clazz.getSimpleName();
                lines.add("<p><h1 id=\"" + name + "\">" + name + "</h1>");
                lines.add("<table>\n<tr><th>Function</th><th>Return Type</th><th>Parameters</th></tr>");
                for (Method method : clazz.getMethods()) {
                    if (ignoredMethods.contains(method.getName()) || Modifier.isStatic(method.getModifiers())) continue;
                    lines.add("<tr>");
                    lines.add("<td>" + method.getName() + "</td>");
                    lines.add("<td>" + method.getReturnType().getSimpleName() + "</td>");
                    lines.add("<td>");
                    if (method.getParameterCount() <= 0) {
                        lines.add("/");
                    } else {
                        for (int i = 0; i < method.getParameterCount(); ++i) {
                            String parameterName = method.getParameters()[i].getName();
                            ScriptParameterName scriptParameterName = method.getParameters()[i].getAnnotation(ScriptParameterName.class);
                            if (scriptParameterName != null) {
                                parameterName = scriptParameterName.value();
                            }
                            lines.add("<strong>" + parameterName + "</strong> - " + method.getParameterTypes()[i].getSimpleName());
                            if (method.getParameterCount() <= 1 || i - 2 > method.getParameterCount()) continue;
                            lines.add("<br>");
                        }
                    }
                    lines.add("</td>");
                    lines.add("</tr>");
                }
                lines.add("</table>");
                lines.add("</p><hr>\n");
            }
            for (String s : lines) {
                bw.write(s + "\n");
            }
            bw.close();
            ThreeCore.LOGGER.info("Successfully generated " + file.getName() + "!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

