/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.events;

import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.threetag.threecore.client.renderer.entity.model.BipedModelParser;
import net.threetag.threecore.event.SetRotationAnglesEvent;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.events.LivingScriptEvent;
import net.threetag.threecore.util.RenderUtil;

public class SetRotationAnglesScriptEvent
extends LivingScriptEvent {
    public SetRotationAnglesEvent event;

    public SetRotationAnglesScriptEvent(SetRotationAnglesEvent event) {
        super(event.getEntityLiving());
        this.event = event;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    public float getLimbSwing() {
        return this.event.limbSwing;
    }

    public float getLimbSwingAmount() {
        return this.event.limbSwingAmount;
    }

    public float getAgeInTicks() {
        return this.event.ageInTicks;
    }

    public float getNetHeadYaw() {
        return this.event.netHeadYaw;
    }

    public float getHeadPitch() {
        return this.event.headPitch;
    }

    public float getPartialTicks() {
        return RenderUtil.renderTickTime;
    }

    public void setRotationAngle(@ScriptParameterName(value="part") String part, @ScriptParameterName(value="xyz") String xyz, @ScriptParameterName(value="angle") float angle) {
        ModelRenderer modelRenderer = null;
        if (this.event.model instanceof BipedModelParser.ParsedBipedModel) {
            modelRenderer = ((BipedModelParser.ParsedBipedModel)this.event.model).getNamedPart(part);
        } else if (this.event.model instanceof PlayerModel) {
            // empty if block
        }
        if (modelRenderer == null) {
            switch (part) {
                case "head": {
                    modelRenderer = this.event.model.field_78116_c;
                    break;
                }
                case "headwear": 
                case "head_overlay": {
                    modelRenderer = this.event.model.field_178720_f;
                    break;
                }
                case "body": {
                    modelRenderer = this.event.model.field_78115_e;
                    break;
                }
                case "rightArm": 
                case "right_arm": {
                    modelRenderer = this.event.model.field_178723_h;
                    break;
                }
                case "leftArm": 
                case "left_arm": {
                    modelRenderer = this.event.model.field_178724_i;
                    break;
                }
                case "rightLeg": 
                case "right_leg": {
                    modelRenderer = this.event.model.field_178721_j;
                    break;
                }
                case "leftLeg": 
                case "left_leg": {
                    modelRenderer = this.event.model.field_178722_k;
                }
            }
        }
        if (modelRenderer != null) {
            switch (xyz) {
                case "x": {
                    modelRenderer.field_78795_f = (float)Math.toRadians(angle);
                    break;
                }
                case "y": {
                    modelRenderer.field_78796_g = (float)Math.toRadians(angle);
                    break;
                }
                case "z": {
                    modelRenderer.field_78808_h = (float)Math.toRadians(angle);
                }
            }
        }
    }
}

