/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.threetag.threecore.block.EnergyConduitBlock;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.energy.EnergyStorageExt;

public class EnergyConduitTileEntity
extends TileEntity
implements ITickableTileEntity {
    public EnergyStorageExt energyStorage;
    private LazyOptional<IEnergyStorage> energyStorageLazyOptional;
    protected EnergyConduitBlock.ConduitType field_200663_e;

    public EnergyConduitTileEntity(EnergyConduitBlock.ConduitType type) {
        super((TileEntityType)TCTileEntityTypes.CONDUIT.get());
        this.field_200663_e = type;
        this.energyStorage = new EnergyStorageExt(type.getTransferRate().getAsInt() * 5, type.getTransferRate().getAsInt());
        this.energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        for (Direction direction : Direction.values()) {
            if (!((EnergyConduitBlock.ConduitConnection)((Object)state.func_177229_b((Property)EnergyConduitBlock.FACING_TO_PROPERTY_MAP.get(direction)))).hasConnection()) continue;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tileEntity instanceof EnergyConduitTileEntity) {
                EnergyStorageExt otherCableEnergy = ((EnergyConduitTileEntity)tileEntity).energyStorage;
                if (this.energyStorage.getEnergyStored() <= otherCableEnergy.getEnergyStored() || Math.abs(this.energyStorage.getEnergyStored() - otherCableEnergy.getEnergyStored()) <= 1) continue;
                int transfer = (this.energyStorage.getEnergyStored() - otherCableEnergy.getEnergyStored()) / 2;
                this.energyStorage.modifyEnergy(-otherCableEnergy.receiveEnergy(Math.min(transfer, this.energyStorage.getMaxExtract()), false));
                continue;
            }
            if (tileEntity == null) continue;
            tileEntity.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).ifPresent(machineEnergy -> this.energyStorage.modifyEnergy(-machineEnergy.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxExtract()), false)));
        }
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.field_200663_e = EnergyConduitBlock.ConduitType.getByName(nbt.func_74779_i("Type"));
        this.energyStorage = new EnergyStorageExt(this.field_200663_e.getTransferRate().getAsInt() * 5, this.field_200663_e.getTransferRate().getAsInt(), this.field_200663_e.getTransferRate().getAsInt(), nbt.func_74762_e("Energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74778_a("Type", this.field_200663_e.getName());
        nbt.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(nbt);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityEnergy.ENERGY ? this.energyStorageLazyOptional.cast() : LazyOptional.empty();
    }
}

