/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.container.FluidComposerContainer;
import net.threetag.threecore.fluid.FluidTankExt;
import net.threetag.threecore.item.FluidInventory;
import net.threetag.threecore.item.ItemStackHandlerExt;
import net.threetag.threecore.item.recipe.FluidComposingRecipe;
import net.threetag.threecore.tileentity.ProgressableMachineTileEntity;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.PlayerUtil;
import net.threetag.threecore.util.TCFluidUtil;
import net.threetag.threecore.util.energy.IEnergyConfig;

public class FluidComposerTileEntity
extends ProgressableMachineTileEntity<FluidComposingRecipe> {
    public static final int TANK_CAPACITY = 5000;
    protected final IIntArray intArray = new IIntArray(){

        public int func_221476_a(int i) {
            switch (i) {
                case 0: {
                    return FluidComposerTileEntity.this.progress;
                }
                case 1: {
                    return FluidComposerTileEntity.this.maxProgress;
                }
                case 2: {
                    return FluidComposerTileEntity.this.energyStorage.getEnergyStored();
                }
                case 3: {
                    return FluidComposerTileEntity.this.energyStorage.getMaxEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int i, int value) {
            switch (i) {
                case 0: {
                    FluidComposerTileEntity.this.progress = value;
                }
                case 1: {
                    FluidComposerTileEntity.this.maxProgress = value;
                }
                case 2: {
                    FluidComposerTileEntity.this.energyStorage.setEnergyStored(value);
                }
                case 3: {
                    FluidComposerTileEntity.this.energyStorage.setMaxEnergyStored(value);
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    public FluidTankExt inputFluidTank = new FluidTankExt(5000).setCallback(f -> {
        this.updateRecipe((IInventory)this.recipeWrapper);
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }).setSoundHandler(sound -> {
        if (sound != null && this.func_145831_w() != null) {
            PlayerUtil.playSoundToAll(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 50.0, sound, SoundCategory.BLOCKS);
        }
    });
    public FluidTankExt outputFluidTank = new FluidTankExt(5000).setCallback(f -> {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }).setSoundHandler(sound -> {
        if (sound != null && this.func_145831_w() != null) {
            PlayerUtil.playSoundToAll(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 50.0, sound, SoundCategory.BLOCKS);
        }
    });
    private ItemStackHandlerExt energySlot = new ItemStackHandlerExt(1).setValidator((TriPredicate<ItemStackHandlerExt, Integer, ItemStack>)((TriPredicate)(handler, slot, stack) -> stack.getCapability(CapabilityEnergy.ENERGY).isPresent())).setChangedCallback((handler, slot) -> this.func_70296_d());
    private ItemStackHandlerExt inputSlots = new ItemStackHandlerExt(9).setChangedCallback((handler, slot) -> {
        this.updateRecipe((IInventory)this.recipeWrapper);
        this.func_70296_d();
    });
    private ItemStackHandlerExt fluidSlots = new ItemStackHandlerExt(4){

        public int getSlotLimit(int slot) {
            return 1;
        }
    }.setValidator((TriPredicate<ItemStackHandlerExt, Integer, ItemStack>)((TriPredicate)(handler, slot, stack) -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent())).setChangedCallback((handler, slot) -> {
        FluidTankExt tank;
        this.func_70296_d();
        FluidTankExt fluidTankExt = tank = slot <= 1 ? this.inputFluidTank : this.outputFluidTank;
        if (slot == 0 || slot == 2) {
            FluidActionResult res = TCFluidUtil.transferFluidFromItemToTank(handler.getStackInSlot(slot), (IFluidHandler)tank, (IItemHandler)handler, null);
            if (res.isSuccess()) {
                handler.setStackInSlot(slot, res.getResult());
            }
        } else {
            FluidActionResult res = TCFluidUtil.transferFluidFromTankToItem(handler.getStackInSlot(slot), (IFluidHandler)tank, (IItemHandler)handler, null);
            if (res.isSuccess()) {
                handler.setStackInSlot(slot, res.getResult());
            }
        }
    });
    private CombinedInvWrapper combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.energySlot, this.fluidSlots, this.inputSlots});
    public FluidInventory recipeWrapper = new FluidInventory((IItemHandlerModifiable)this.inputSlots, (IFluidTank)this.inputFluidTank);
    private LazyOptional<IItemHandlerModifiable> combinedInvLazyOptional = LazyOptional.of(() -> this.combinedHandler);
    private LazyOptional<IItemHandlerModifiable> energySlotLazyOptional = LazyOptional.of(() -> this.energySlot);
    private LazyOptional<IItemHandlerModifiable> fluidSlotLazyOptional = LazyOptional.of(() -> this.fluidSlots);
    private LazyOptional<IItemHandlerModifiable> inputLazyOptional = LazyOptional.of(() -> this.inputSlots);
    private LazyOptional<IFluidHandler> inputFluidHandler = LazyOptional.of(() -> this.inputFluidTank);
    private LazyOptional<IFluidHandler> outputFluidHandler = LazyOptional.of(() -> this.outputFluidTank);

    public FluidComposerTileEntity() {
        super((TileEntityType)TCTileEntityTypes.FLUID_COMPOSER.get());
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.threecore.fluid_composer");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new FluidComposerContainer(id, player, this, this.intArray);
    }

    @Override
    public IRecipeType<FluidComposingRecipe> getRecipeType() {
        return FluidComposingRecipe.RECIPE_TYPE;
    }

    @Override
    public IEnergyConfig getEnergyConfig() {
        return ThreeCoreServerConfig.ENERGY.FLUID_COMPOSER;
    }

    @Override
    public IItemHandler getEnergyInputSlots() {
        return this.energySlot;
    }

    @Override
    public boolean canWork(FluidComposingRecipe recipe) {
        FluidStack result = recipe.getResult((IInventory)this.recipeWrapper);
        if (result.isEmpty()) {
            return false;
        }
        return this.outputFluidTank.fill(result, IFluidHandler.FluidAction.SIMULATE) == result.getAmount();
    }

    @Override
    public void produceOutput(FluidComposingRecipe recipe) {
        if (!TCFluidUtil.drainIngredient((IFluidTank)this.inputFluidTank, recipe.getInputFluid(), IFluidHandler.FluidAction.EXECUTE)) {
            return;
        }
        this.outputFluidTank.fill(recipe.getResult((IInventory)this.recipeWrapper), IFluidHandler.FluidAction.EXECUTE);
        for (int i = 0; i < this.inputSlots.getSlots(); ++i) {
            this.inputSlots.getStackInSlot(i).func_190918_g(1);
        }
        this.updateRecipe((IInventory)this.recipeWrapper);
    }

    @Override
    public IItemHandler getEnergyOutputSlots() {
        return super.getEnergyOutputSlots();
    }

    protected IItemHandler createUnSidedHandler() {
        return super.createUnSidedHandler();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.inputFluidTank.readFromNBT(tag.func_74775_l("InputFluid"));
        this.outputFluidTank.readFromNBT(tag.func_74775_l("OutputFluid"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("InputFluid", (INBT)this.inputFluidTank.writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("OutputFluid", (INBT)this.outputFluidTank.writeToNBT(new CompoundNBT()));
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        if (nbt.func_74764_b("EnergySlots")) {
            this.energySlot.deserializeNBT(nbt.func_74775_l("EnergySlots"));
        }
        if (nbt.func_74764_b("InputSlots")) {
            this.inputSlots.deserializeNBT(nbt.func_74775_l("InputSlots"));
        }
        if (nbt.func_74764_b("FluidSlots")) {
            this.fluidSlots.deserializeNBT(nbt.func_74775_l("FluidSlots"));
        }
        this.inputFluidTank.readFromNBT(nbt.func_74775_l("InputFluid"));
        this.outputFluidTank.readFromNBT(nbt.func_74775_l("OutputFluid"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("EnergySlots", (INBT)this.energySlot.serializeNBT());
        nbt.func_218657_a("InputSlots", (INBT)this.inputSlots.serializeNBT());
        nbt.func_218657_a("FluidSlots", (INBT)this.fluidSlots.serializeNBT());
        nbt.func_218657_a("InputFluid", (INBT)this.inputFluidTank.writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("OutputFluid", (INBT)this.outputFluidTank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(nbt);
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.combinedInvLazyOptional.cast();
            }
            if (side == Direction.UP) {
                return this.inputLazyOptional.cast();
            }
            if (side == Direction.DOWN) {
                return this.fluidSlotLazyOptional.cast();
            }
            return this.energySlotLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == Direction.UP || side == Direction.DOWN) {
                return this.outputFluidHandler.cast();
            }
            return this.inputFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

