/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.threetag.threecore.tileentity.LockableItemCapTileEntity;
import net.threetag.threecore.util.energy.EnergyStorageExt;
import net.threetag.threecore.util.energy.IEnergyConfig;
import net.threetag.threecore.util.energy.IEnergyStorageModifiable;

public abstract class MachineTileEntity
extends LockableItemCapTileEntity
implements ITickableTileEntity {
    protected IEnergyStorageModifiable energyStorage;
    private LazyOptional<IEnergyStorage> energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);

    public MachineTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
        this.energyStorage = this.createEnergyStorage(0);
    }

    protected IEnergyStorageModifiable createEnergyStorage(int energy) {
        return new EnergyStorageExt(this.getEnergyConfig(), energy);
    }

    public abstract IEnergyConfig getEnergyConfig();

    public IItemHandler getEnergyInputSlots() {
        return null;
    }

    public IItemHandler getEnergyOutputSlots() {
        return null;
    }

    public void func_73660_a() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            int i;
            if (this.getEnergyInputSlots() != null) {
                for (i = 0; i < this.getEnergyInputSlots().getSlots(); ++i) {
                    this.getEnergyInputSlots().getStackInSlot(i).getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                        int energy = energyStorage.extractEnergy(energyStorage.getEnergyStored(), true);
                        if ((energy = this.energyStorage.receiveEnergy(energy, true)) > 0) {
                            this.energyStorage.receiveEnergy(energy, false);
                            energyStorage.extractEnergy(energy, false);
                        }
                    });
                }
            }
            if (this.getEnergyOutputSlots() != null) {
                for (i = 0; i < this.getEnergyOutputSlots().getSlots(); ++i) {
                    this.getEnergyOutputSlots().getStackInSlot(i).getCapability(CapabilityEnergy.ENERGY).ifPresent(energyStorage -> {
                        int energy = this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored(), true);
                        if ((energy = energyStorage.receiveEnergy(energy, true)) > 0) {
                            energyStorage.receiveEnergy(energy, false);
                            this.energyStorage.extractEnergy(energy, false);
                        }
                    });
                }
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (Objects.requireNonNull(this.field_145850_b).func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorageLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.energyStorage = this.createEnergyStorage(nbt.func_74762_e("Energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(nbt);
    }
}

