/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TCJsonUtil {
    public static int[] getIntArray(JsonObject jsonObject, int fields, String key, int ... fallback) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)key)) {
            return fallback;
        }
        JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)key);
        if (jsonArray.size() != fields) {
            throw new JsonParseException("Array " + key + " must have " + fields + " entries!");
        }
        int[] array = new int[fields];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsInt();
        }
        return array;
    }

    public static float[] getFloatArray(JsonObject jsonObject, int fields, String key, float ... fallback) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)key)) {
            return fallback;
        }
        JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)key);
        if (jsonArray.size() != fields) {
            throw new JsonParseException("Array " + key + " must have " + fields + " entries!");
        }
        float[] array = new float[fields];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsFloat();
        }
        return array;
    }

    public static JsonObject merge(JsonObject json1, JsonObject json2) {
        JsonObject json = JSONUtils.func_212745_a((String)json1.toString());
        json2.entrySet().forEach(entry -> {
            if (!json.has((String)entry.getKey())) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            } else if (json.get((String)entry.getKey()).isJsonPrimitive() && ((JsonElement)entry.getValue()).isJsonPrimitive()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            } else if (json.get((String)entry.getKey()).isJsonArray() && ((JsonElement)entry.getValue()).isJsonArray()) {
                JsonArray jsonArray = json.get((String)entry.getKey()).getAsJsonArray();
                JsonArray json2Array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (int i = 0; i < json2Array.size(); ++i) {
                    jsonArray.add(json2Array.get(i));
                }
                json.add((String)entry.getKey(), (JsonElement)jsonArray);
            } else if (json.get((String)entry.getKey()).isJsonObject() && ((JsonElement)entry.getValue()).isJsonObject()) {
                json.add((String)entry.getKey(), (JsonElement)TCJsonUtil.merge(json.get((String)entry.getKey()).getAsJsonObject(), ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        });
        return json;
    }

    public static JsonElement nbtToJson(INBT nbt) {
        if (nbt instanceof NumberNBT) {
            return new JsonPrimitive(((NumberNBT)nbt).func_209908_j());
        }
        if (nbt instanceof CollectionNBT) {
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < ((CollectionNBT)nbt).size(); ++i) {
                jsonArray.add(TCJsonUtil.nbtToJson((INBT)((CollectionNBT)nbt).get(i)));
            }
            return jsonArray;
        }
        if (nbt instanceof StringNBT) {
            return new JsonPrimitive(nbt.func_150285_a_());
        }
        if (nbt instanceof CompoundNBT) {
            JsonObject jsonObject = new JsonObject();
            for (String key : ((CompoundNBT)nbt).func_150296_c()) {
                jsonObject.add(key, TCJsonUtil.nbtToJson(((CompoundNBT)nbt).func_74781_a(key)));
            }
            return jsonObject;
        }
        return new JsonObject();
    }

    public static JsonObject serializeItemStack(ItemStack stack) {
        return TCJsonUtil.serializeItemStack(stack, true);
    }

    public static JsonObject serializeItemStack(ItemStack stack, boolean writeNbt) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString());
        json.addProperty("count", (Number)stack.func_190916_E());
        if (writeNbt && stack.func_77942_o()) {
            json.add("nbt", TCJsonUtil.nbtToJson((INBT)stack.func_77978_p()));
        }
        return json;
    }
}

