/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.energy;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyUtil {
    public static final String ENERGY_UNIT = "FE";

    @OnlyIn(value=Dist.CLIENT)
    public static ITextComponent getFormattedEnergy(int energy, int maxEnergy) {
        return new StringTextComponent(I18n.func_135052_a((String)"threecore.util.energy_storage_display", (Object[])new Object[]{energy, maxEnergy, ENERGY_UNIT}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ITextComponent getFormattedEnergy(IEnergyStorage energyStorage) {
        return EnergyUtil.getFormattedEnergy(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawTooltip(MatrixStack stack, EnergyStorage energyStorage, ContainerScreen gui, int x, int y, int width, int height, int mouseX, int mouseY) {
        EnergyUtil.drawTooltip(stack, energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored(), gui, x, y, width, height, mouseX, mouseY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawTooltip(MatrixStack stack, int energy, int maxEnergy, ContainerScreen gui, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height) {
            gui.func_238652_a_(stack, EnergyUtil.getFormattedEnergy(energy, maxEnergy), mouseX + 10, mouseY);
        }
    }
}

