/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.entityeffect;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.util.entityeffect.EffectEntity;
import net.threetag.threecore.util.entityeffect.EntityEffect;
import net.threetag.threecore.util.threedata.ThreeData;

public class EntityEffectUpdateMessage {
    public int entityId;
    public String dataKey;
    public CompoundNBT dataTag;

    public EntityEffectUpdateMessage(int entityId, String dataKey, CompoundNBT dataTag) {
        this.entityId = entityId;
        this.dataKey = dataKey;
        this.dataTag = dataTag;
    }

    public EntityEffectUpdateMessage(PacketBuffer buf) {
        this.entityId = buf.readInt();
        this.dataKey = buf.func_150789_c(32);
        this.dataTag = buf.func_150793_b();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.func_180714_a(this.dataKey);
        buf.func_150786_a(this.dataTag);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityId);
            if (entity instanceof EffectEntity) {
                EntityEffect entityEffect = ((EffectEntity)entity).entityEffect;
                ThreeData data = entityEffect.getDataByName(this.dataKey);
                entityEffect.readValue(data, this.dataTag);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

