/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.util.threedata.ThreeData;

public class AttributeThreeData
extends ThreeData<Attribute> {
    public AttributeThreeData(String key) {
        super(key);
    }

    @Override
    public Attribute parseValue(JsonObject jsonObject, Attribute defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey)));
        if (attribute == null) {
            throw new JsonSyntaxException("Attribute " + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey) + " does not exist!");
        }
        return attribute;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, Attribute value) {
        nbt.func_74778_a(this.key, Objects.requireNonNull(ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)value)).toString());
    }

    @Override
    public Attribute readFromNBT(CompoundNBT nbt, Attribute defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(nbt.func_74779_i(this.key)));
        return attribute != null ? attribute : defaultValue;
    }

    @Override
    public JsonElement serializeJson(Attribute value) {
        return new JsonPrimitive(ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)value).toString());
    }
}

