/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.util.INBTSerializable;
import net.threetag.threecore.util.threedata.ThreeData;

public class CommandListThreeData
extends ThreeData<CommandList> {
    public CommandListThreeData(String key) {
        super(key);
    }

    @Override
    public CommandList parseValue(JsonObject jsonObject, CommandList defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        return new CommandList(jsonObject.get(this.jsonKey));
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, CommandList value) {
        nbt.func_218657_a(this.key, (INBT)value.serializeNBT());
    }

    @Override
    public CommandList readFromNBT(CompoundNBT nbt, CommandList defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        CommandList list = new CommandList();
        list.deserializeNBT(nbt.func_150295_c(this.key, 8));
        return list;
    }

    @Override
    public JsonElement serializeJson(CommandList value) {
        return value.serializeJson();
    }

    public static class CommandList
    implements INBTSerializable<ListNBT> {
        private List<String> commands;

        public CommandList() {
            this(new LinkedList<String>());
        }

        public CommandList(JsonElement jsonElement) {
            this.parseJson(jsonElement);
        }

        public CommandList(List<String> commands) {
            this.commands = commands;
        }

        public CommandList addCommand(String command) {
            this.commands.add(command);
            return this;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public ListNBT serializeNBT() {
            ListNBT list = new ListNBT();
            for (int i = 0; i < this.commands.size(); ++i) {
                list.add(i, (INBT)StringNBT.func_229705_a_((String)this.commands.get(i)));
            }
            return list;
        }

        public void deserializeNBT(ListNBT nbt) {
            this.commands = new LinkedList<String>();
            for (int i = 0; i < nbt.size(); ++i) {
                this.commands.add(nbt.func_150307_f(i));
            }
        }

        public void parseJson(JsonElement jsonElement) {
            this.commands = new LinkedList<String>();
            if (jsonElement.isJsonPrimitive()) {
                this.commands.add(jsonElement.getAsString());
            } else {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.commands.add(jsonArray.get(i).getAsString());
                }
            }
        }

        public JsonElement serializeJson() {
            if (this.commands.size() == 1) {
                return new JsonPrimitive(this.commands.get(0));
            }
            JsonArray array = new JsonArray();
            for (String s : this.commands) {
                array.add(s);
            }
            return array;
        }
    }
}

