/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.util.threedata.ThreeData;

public class EntityTypeThreeData
extends ThreeData<EntityType<?>> {
    public EntityTypeThreeData(String key) {
        super(key);
    }

    @Override
    public EntityType<?> parseValue(JsonObject jsonObject, EntityType<?> defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey)));
        if (entityType == null) {
            throw new JsonSyntaxException("Entity type " + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey) + " does not exist!");
        }
        return entityType;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, EntityType<?> value) {
        nbt.func_74778_a(this.key, Objects.requireNonNull(value.getRegistryName()).toString());
    }

    @Override
    public EntityType<?> readFromNBT(CompoundNBT nbt, EntityType<?> defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        return (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(nbt.func_74779_i(this.key)));
    }

    @Override
    public JsonElement serializeJson(EntityType<?> value) {
        return new JsonPrimitive(ForgeRegistries.ENTITIES.getKey(value).toString());
    }
}

